/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;

public class GenericToStringSerializer<T>
implements RedisSerializer<T>,
BeanFactoryAware {
    private final Class<T> type;
    private final Charset charset;
    private Converter converter;

    public GenericToStringSerializer(Class<T> type) {
        this(type, StandardCharsets.UTF_8);
    }

    public GenericToStringSerializer(Class<T> type, Charset charset) {
        Assert.notNull(type, (String)"Type must not be null");
        this.type = type;
        this.charset = charset;
        this.converter = new Converter(DefaultConversionService.getSharedInstance());
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.converter = new Converter(conversionService);
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        Assert.notNull((Object)typeConverter, (String)"TypeConverter must not be null");
        this.converter = new Converter(typeConverter);
    }

    @Override
    public byte @Nullable [] serialize(@Nullable T value) {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        String string = this.converter.convert(value, String.class);
        return string.getBytes(this.charset);
    }

    @Override
    public @Nullable T deserialize(byte @Nullable [] bytes) {
        if (bytes == null) {
            return null;
        }
        String string = new String(bytes, this.charset);
        return this.converter.convert(string, this.type);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    private static final class Converter {
        private final @Nullable ConversionService conversionService;
        private final @Nullable TypeConverter typeConverter;

        public Converter(ConversionService conversionService) {
            this.conversionService = conversionService;
            this.typeConverter = null;
        }

        public Converter(TypeConverter typeConverter) {
            this.conversionService = null;
            this.typeConverter = typeConverter;
        }

        <E> @Nullable E convert(Object value, Class<E> targetType) {
            return (E)(this.conversionService != null ? this.conversionService.convert(value, targetType) : this.typeConverter.convertIfNecessary(value, targetType));
        }
    }
}

