/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.lang.model.SourceVersion;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class FlatEric {
    FlatEric() {
    }

    static Map<String, Object> unflatten(Map<String, Object> source) {
        LinkedHashMap result = CollectionUtils.newLinkedHashMap((int)source.size());
        LinkedHashSet treatSeparate = CollectionUtils.newLinkedHashSet((int)source.size());
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            String[] keyParts = key.split("\\.");
            if (keyParts.length == 1 && FlatEric.isNotIndexed(keyParts[0])) {
                result.put(key, entry.getValue());
                continue;
            }
            if (keyParts.length == 1 && FlatEric.isIndexed((String)keyParts[0])) {
                Object object = keyParts[0];
                String nonIndexedKeyName = FlatEric.stripIndex((String)object);
                int index = FlatEric.getIndex((String)object);
                if (result.containsKey(nonIndexedKeyName)) {
                    FlatEric.addValueToTypedListAtIndex((List)result.get(nonIndexedKeyName), index, entry.getValue());
                    continue;
                }
                result.put(nonIndexedKeyName, FlatEric.createTypedListWithValue(index, entry.getValue()));
                continue;
            }
            treatSeparate.add(keyParts[0]);
        }
        for (String partial : treatSeparate) {
            LinkedHashMap<String, Object> newSource = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : source.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(partial)) continue;
                String keyAfterDot = key.substring(partial.length() + 1);
                newSource.put(keyAfterDot, entry.getValue());
            }
            if (FlatEric.isNonNestedIndexed(partial)) {
                String nonIndexPartial = FlatEric.stripIndex(partial);
                int n = FlatEric.getIndex(partial);
                if (result.containsKey(nonIndexPartial)) {
                    FlatEric.addValueToTypedListAtIndex((List)result.get(nonIndexPartial), n, FlatEric.unflatten(newSource));
                    continue;
                }
                result.put(nonIndexPartial, FlatEric.createTypedListWithValue(n, FlatEric.unflatten(newSource)));
                continue;
            }
            result.put(partial, FlatEric.unflatten(newSource));
        }
        return result;
    }

    private static void addValueToTypedListAtIndex(List<Object> listWithTypeHint, int index, Object value) {
        ArrayList<Object> valueList = (ArrayList<Object>)listWithTypeHint.get(1);
        if (index >= valueList.size()) {
            int initialCapacity = index + 1;
            ArrayList<Object> newValueList = new ArrayList<Object>(initialCapacity);
            Collections.copy(org.springframework.data.redis.support.collections.CollectionUtils.initializeList(newValueList, initialCapacity), valueList);
            listWithTypeHint.set(1, newValueList);
            valueList = newValueList;
        }
        valueList.set(index, value);
    }

    private static List<Object> createTypedListWithValue(int index, Object value) {
        int initialCapacity = index + 1;
        List<Object> valueList = org.springframework.data.redis.support.collections.CollectionUtils.initializeList(new ArrayList(initialCapacity), initialCapacity);
        valueList.set(index, value);
        ArrayList<Object> listWithTypeHint = new ArrayList<Object>();
        listWithTypeHint.add(ArrayList.class.getName());
        listWithTypeHint.add(valueList);
        return listWithTypeHint;
    }

    private static boolean isIndexed(String value) {
        return value.indexOf(91) > -1;
    }

    private static boolean isNotIndexed(String value) {
        return !FlatEric.isIndexed(value);
    }

    private static boolean isNonNestedIndexed(String value) {
        return value.endsWith("]");
    }

    private static int getIndex(String indexedValue) {
        return Integer.parseInt(indexedValue.substring(indexedValue.indexOf(91) + 1, indexedValue.length() - 1));
    }

    private static String stripIndex(String indexedValue) {
        int indexOfLeftBracket = indexedValue.indexOf("[");
        return indexOfLeftBracket > -1 ? indexedValue.substring(0, indexOfLeftBracket) : indexedValue;
    }

    static Map<String, Object> flatten(JsonNodeAdapterFactory adapterFactory, Collection<? extends Map.Entry<String, ?>> source) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(source.size());
        FlatEric.flatten(adapterFactory, "", source, resultMap::put);
        return resultMap;
    }

    private static void flatten(JsonNodeAdapterFactory adapterFactory, String propertyPrefix, Collection<? extends Map.Entry<String, ?>> inputMap, BiConsumer<String, Object> sink) {
        if (StringUtils.hasText((String)propertyPrefix)) {
            propertyPrefix = (String)propertyPrefix + ".";
        }
        for (Map.Entry<String, ?> entry : inputMap) {
            FlatEric.flattenElement(adapterFactory, (String)propertyPrefix + entry.getKey(), entry.getValue(), sink);
        }
    }

    private static void flattenElement(JsonNodeAdapterFactory adapterFactory, String propertyPrefix, Object source, BiConsumer<String, Object> sink) {
        if (!adapterFactory.isJsonNode(source)) {
            sink.accept(propertyPrefix, source);
            return;
        }
        JsonNodeAdapter adapter = adapterFactory.adapt(source);
        if (adapter.isArray()) {
            Iterator<? extends JsonNodeAdapter> nodes = adapter.values().iterator();
            while (nodes.hasNext()) {
                JsonNodeAdapter currentNode = nodes.next();
                if (currentNode.isArray()) {
                    FlatEric.flattenCollection(adapterFactory, propertyPrefix, currentNode.values(), sink);
                    continue;
                }
                if (!nodes.hasNext() || !FlatEric.mightBeJavaType(currentNode)) continue;
                JsonNodeAdapter next = nodes.next();
                if (next.isArray()) {
                    FlatEric.flattenCollection(adapterFactory, propertyPrefix, next.values(), sink);
                }
                if (currentNode.asString().equals("java.util.Date")) {
                    sink.accept(propertyPrefix, next.asString());
                    break;
                }
                if (next.isNumber()) {
                    sink.accept(propertyPrefix, next.numberValue());
                    break;
                }
                if (next.isString()) {
                    sink.accept(propertyPrefix, next.stringValue());
                    break;
                }
                if (next.isBoolean()) {
                    sink.accept(propertyPrefix, next.booleanValue());
                    break;
                }
                if (!next.isBinary()) continue;
                try {
                    sink.accept(propertyPrefix, next.binaryValue());
                    break;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Cannot read binary value '%s'".formatted(propertyPrefix), ex);
                }
            }
        } else if (adapter.isObject()) {
            FlatEric.flatten(adapterFactory, propertyPrefix, adapter.properties(), sink);
        } else {
            switch (adapter.getNodeType().ordinal()) {
                case 8: {
                    sink.accept(propertyPrefix, adapter.stringValue());
                    break;
                }
                case 5: {
                    sink.accept(propertyPrefix, adapter.numberValue());
                    break;
                }
                case 2: {
                    sink.accept(propertyPrefix, adapter.booleanValue());
                    break;
                }
                case 1: {
                    try {
                        sink.accept(propertyPrefix, adapter.binaryValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                default: {
                    sink.accept(propertyPrefix, adapter.getDirectValue());
                }
            }
        }
    }

    private static boolean mightBeJavaType(JsonNodeAdapter node) {
        String textValue = node.asString();
        return SourceVersion.isName(textValue);
    }

    private static void flattenCollection(JsonNodeAdapterFactory adapterFactory, String propertyPrefix, Collection<? extends JsonNodeAdapter> list, BiConsumer<String, Object> sink) {
        Iterator<? extends JsonNodeAdapter> iterator = list.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            JsonNodeAdapter element = iterator.next();
            FlatEric.flattenElement(adapterFactory, propertyPrefix + "[" + counter + "]", element, sink);
            ++counter;
        }
    }

    public static interface JsonNodeAdapterFactory {
        public JsonNodeAdapter adapt(Object var1);

        public boolean isJsonNode(Object var1);
    }

    public static interface JsonNodeAdapter {
        public JsonNodeType getNodeType();

        public boolean isArray();

        public Collection<? extends JsonNodeAdapter> values();

        public String asString();

        public boolean isNumber();

        public Number numberValue();

        public boolean isString();

        public String stringValue();

        public boolean isBoolean();

        public boolean booleanValue();

        public boolean isBinary();

        public byte[] binaryValue();

        public boolean isObject();

        public Collection<Map.Entry<String, JsonNodeAdapter>> properties();

        public Object getDirectValue();
    }

    public static enum JsonNodeType {
        ARRAY,
        BINARY,
        BOOLEAN,
        MISSING,
        NULL,
        NUMBER,
        OBJECT,
        POJO,
        STRING;

    }
}

