/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.args.SaveMode;

@NullUnmarked
class JedisServerCommands
implements RedisServerCommands {
    private final JedisConnection connection;

    JedisServerCommands(@NonNull JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof() {
        this.connection.invoke().just(Jedis::bgrewriteaof);
    }

    @Override
    public void bgSave() {
        this.connection.invokeStatus().just(Jedis::bgsave);
    }

    @Override
    public Long lastSave() {
        return this.connection.invoke().just(Jedis::lastsave);
    }

    @Override
    public void save() {
        this.connection.invokeStatus().just(Jedis::save);
    }

    @Override
    public Long dbSize() {
        return this.connection.invoke().just(Jedis::dbSize);
    }

    @Override
    public void flushDb() {
        this.connection.invokeStatus().just(Jedis::flushDB);
    }

    @Override
    public void flushDb(@NonNull RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(j -> j.flushDB(JedisConverters.toFlushMode(option)));
    }

    @Override
    public void flushAll() {
        this.connection.invokeStatus().just(Jedis::flushAll);
    }

    @Override
    public void flushAll(@NonNull RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(j -> j.flushAll(JedisConverters.toFlushMode(option)));
    }

    @Override
    public Properties info() {
        return (Properties)this.connection.invoke().from(Jedis::info).get(Converters::toProperties);
    }

    @Override
    public Properties info(@NonNull String section) {
        Assert.notNull((Object)section, (String)"Section must not be null");
        return (Properties)this.connection.invoke().from(j -> j.info(section)).get(Converters::toProperties);
    }

    @Override
    public void shutdown() {
        this.connection.invokeStatus().just(jedis -> {
            jedis.shutdown();
            return null;
        });
    }

    @Override
    public void shutdown(@Nullable RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        SaveMode saveMode = option == RedisServerCommands.ShutdownOption.NOSAVE ? SaveMode.NOSAVE : SaveMode.SAVE;
        this.connection.getJedis().shutdown(saveMode);
    }

    @Override
    public Properties getConfig(@NonNull String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        return (Properties)this.connection.invoke().from(j -> j.configGet(pattern)).get(Converters::toProperties);
    }

    @Override
    public void setConfig(@NonNull String param, @NonNull String value) {
        Assert.notNull((Object)param, (String)"Parameter must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.connection.invokeStatus().just(j -> j.configSet(param, value));
    }

    @Override
    public void resetConfigStats() {
        this.connection.invokeStatus().just(Jedis::configResetStat);
    }

    @Override
    public void rewriteConfig() {
        this.connection.invokeStatus().just(Jedis::configRewrite);
    }

    @Override
    public Long time(@NonNull TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
        return (Long)this.connection.invoke().from(Jedis::time).get(source -> JedisConverters.toTime(source, timeUnit));
    }

    @Override
    public void killClient(@NonNull String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'");
        this.connection.invokeStatus().just(it -> it.clientKill("%s:%s".formatted(host, port)));
    }

    @Override
    public void setClientName(byte @NonNull [] name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.connection.invokeStatus().just(it -> it.clientSetname(name));
    }

    @Override
    public String getClientName() {
        return this.connection.invokeStatus().just(Jedis::clientGetname);
    }

    @Override
    public List<@NonNull RedisClientInfo> getClientList() {
        return (List)this.connection.invokeStatus().from(Jedis::clientList).get(JedisConverters::toListOfRedisClientInformation);
    }

    @Override
    public void replicaOf(@NonNull String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'REPLICAOF' command");
        this.connection.invokeStatus().just(it -> it.replicaof(host, port));
    }

    @Override
    public void replicaOfNoOne() {
        this.connection.invokeStatus().just(Jedis::replicaofNoOne);
    }

    @Override
    public void migrate(byte @NonNull [] key, @NonNull RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte @NonNull [] key, @NonNull RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)target, (String)"Target node must not be null");
        int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        this.connection.invokeStatus().just(j -> j.migrate(target.getRequiredHost(), target.getRequiredPort(), key, dbIndex, timeoutToUse));
    }
}

