/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveKeyCommands {
    default public Mono<Boolean> copy(ByteBuffer sourceKey, ByteBuffer targetKey, boolean replace) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)targetKey, (String)"Targetk ey must not be null");
        return this.copy((Publisher<CopyCommand>)Mono.just((Object)CopyCommand.key(sourceKey).to(targetKey).replace(replace))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<CopyCommand>> copy(Publisher<CopyCommand> var1);

    default public Mono<Boolean> exists(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.exists((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Mono<Long> exists(List<ByteBuffer> var1);

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<DataType> type(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.type((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> touch(Collection<ByteBuffer> keys) {
        return this.touch((Publisher<Collection<ByteBuffer>>)Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<Collection<ByteBuffer>, Long>> touch(Publisher<Collection<ByteBuffer>> var1);

    default public Mono<List<ByteBuffer>> keys(ByteBuffer pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        return this.keys((Publisher<ByteBuffer>)Mono.just((Object)pattern)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> var1);

    default public Flux<ByteBuffer> scan() {
        return this.scan(ScanOptions.NONE);
    }

    default public Flux<ByteBuffer> scan(KeyScanOptions options) {
        return this.scan((ScanOptions)options);
    }

    public Flux<ByteBuffer> scan(ScanOptions var1);

    public Mono<ByteBuffer> randomKey();

    default public Mono<Boolean> rename(ByteBuffer oldKey, ByteBuffer newKey) {
        Assert.notNull((Object)oldKey, (String)"Key must not be null");
        return this.rename((Publisher<RenameCommand>)Mono.just((Object)RenameCommand.key(oldKey).to(newKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<RenameCommand>> rename(Publisher<RenameCommand> var1);

    default public Mono<Boolean> renameNX(ByteBuffer key, ByteBuffer newKey) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.renameNX((Publisher<RenameCommand>)Mono.just((Object)RenameCommand.key(key).to(newKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<RenameCommand>> renameNX(Publisher<RenameCommand> var1);

    default public Mono<Long> del(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.del((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> mDel(List<ByteBuffer> keys) {
        Assert.notEmpty(keys, (String)"Keys must not be empty or null");
        return this.mDel((Publisher<List<ByteBuffer>>)Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> var1);

    default public Mono<Long> unlink(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Keys must not be null");
        return this.unlink((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)key).map(ReactiveRedisConnection.KeyCommand::new)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> unlink(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> mUnlink(List<ByteBuffer> keys) {
        Assert.notNull(keys, (String)"Keys must not be null");
        return this.mUnlink((Publisher<List<ByteBuffer>>)Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mUnlink(Publisher<List<ByteBuffer>> var1);

    public Flux<ReactiveRedisConnection.BooleanResponse<ExpireCommand>> applyExpiration(Publisher<ExpireCommand> var1);

    default public Mono<Boolean> expire(ByteBuffer key, Duration timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return this.expire((Publisher<ExpireCommand>)Mono.just((Object)new ExpireCommand(key, timeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ReactiveRedisConnection.BooleanResponse<ExpireCommand>> expire(Publisher<ExpireCommand> commands) {
        return this.applyExpiration(commands);
    }

    default public Mono<Boolean> pExpire(ByteBuffer key, Duration timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return this.pExpire((Publisher<ExpireCommand>)Mono.just((Object)new ExpireCommand(key, timeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ReactiveRedisConnection.BooleanResponse<ExpireCommand>> pExpire(Publisher<ExpireCommand> commands) {
        return this.applyExpiration(commands);
    }

    default public Mono<Boolean> expireAt(ByteBuffer key, Instant expireAt) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)expireAt, (String)"Expire at must not be null");
        return this.expireAt((Publisher<ExpireAtCommand>)Mono.just((Object)new ExpireAtCommand(key, expireAt))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ExpireAtCommand>> expireAt(Publisher<ExpireAtCommand> var1);

    default public Mono<Boolean> pExpireAt(ByteBuffer key, Instant expireAt) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)expireAt, (String)"Expire at must not be null");
        return this.pExpireAt((Publisher<ExpireAtCommand>)Mono.just((Object)new ExpireAtCommand(key, expireAt))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ExpireAtCommand>> pExpireAt(Publisher<ExpireAtCommand> var1);

    default public Mono<Boolean> persist(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.persist((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> persist(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> ttl(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.ttl((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> ttl(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> pTtl(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.pTtl((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> pTtl(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Boolean> move(ByteBuffer key, int database) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.move((Publisher<MoveCommand>)Mono.just((Object)new MoveCommand(key, database))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<MoveCommand>> move(Publisher<MoveCommand> var1);

    public Mono<ValueEncoding> encodingOf(ByteBuffer var1);

    public Mono<Duration> idletime(ByteBuffer var1);

    public Mono<Long> refcount(ByteBuffer var1);

    public static class CopyCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final @Nullable ByteBuffer target;
        private final boolean replace;
        private final @Nullable Integer database;

        public CopyCommand(@Nullable ByteBuffer key, @Nullable ByteBuffer target, boolean replace, @Nullable Integer database) {
            super(key);
            this.target = target;
            this.replace = replace;
            this.database = database;
        }

        public static CopyCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new CopyCommand(key, null, false, null);
        }

        public CopyCommand to(ByteBuffer targetKey) {
            Assert.notNull((Object)targetKey, (String)"Key must not be null");
            return new CopyCommand(this.getKey(), targetKey, this.isReplace(), this.database);
        }

        public CopyCommand replace(boolean replace) {
            return new CopyCommand(this.getKey(), this.target, replace, this.database);
        }

        public CopyCommand database(int database) {
            return new CopyCommand(this.getKey(), this.target, this.isReplace(), database);
        }

        public @Nullable ByteBuffer getTarget() {
            return this.target;
        }

        public boolean isReplace() {
            return this.replace;
        }

        public @Nullable Integer getDatabase() {
            return this.database;
        }
    }

    public static class RenameCommand
    extends ReactiveRedisConnection.KeyCommand {
        private @Nullable ByteBuffer newKey;

        private RenameCommand(@Nullable ByteBuffer key, @Nullable ByteBuffer newKey) {
            super(key);
            this.newKey = newKey;
        }

        public static RenameCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new RenameCommand(key, null);
        }

        public RenameCommand to(ByteBuffer newKey) {
            Assert.notNull((Object)newKey, (String)"New key name must not be null");
            return new RenameCommand(this.getKey(), newKey);
        }

        public @Nullable ByteBuffer getNewKey() {
            return this.newKey;
        }
    }

    public static class ExpireCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Expiration expiration;
        private final ExpirationOptions options;

        private ExpireCommand(ByteBuffer key, Duration timeout) {
            this(key, Expiration.from(timeout), ExpirationOptions.none());
        }

        private ExpireCommand(@Nullable ByteBuffer key, Expiration expiration, ExpirationOptions options) {
            super(key);
            this.expiration = expiration;
            this.options = options;
        }

        public static ExpireCommand expire(ByteBuffer key, Expiration expiration) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            Assert.notNull((Object)expiration, (String)"Expiration must not be null");
            return new ExpireCommand(key, expiration, ExpirationOptions.none());
        }

        public static ExpireCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new ExpireCommand(key, Expiration.persistent(), ExpirationOptions.none());
        }

        public ExpireCommand timeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"Timeout must not be null");
            return new ExpireCommand(this.getKey(), Expiration.from(timeout), this.options);
        }

        public ExpireCommand expire(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"Timeout must not be null");
            return new ExpireCommand(this.getKey(), Expiration.from(timeout), this.options);
        }

        public @Nullable Duration getTimeout() {
            if (this.expiration.isUnixTimestamp() || this.expiration.isPersistent()) {
                return null;
            }
            return Duration.ofMillis(this.expiration.getExpirationTimeInMilliseconds());
        }

        public ExpireCommand withOptions(ExpirationOptions options) {
            return new ExpireCommand(this.getKey(), this.getExpiration(), options);
        }

        public Expiration getExpiration() {
            return this.expiration;
        }

        public ExpirationOptions getOptions() {
            return this.options;
        }
    }

    public static class ExpireAtCommand
    extends ReactiveRedisConnection.KeyCommand {
        private @Nullable Instant expireAt;
        private final ExpirationOptions options;

        private ExpireAtCommand(@Nullable ByteBuffer key, @Nullable Instant expireAt) {
            this(key, expireAt, ExpirationOptions.none());
        }

        private ExpireAtCommand(@Nullable ByteBuffer key, @Nullable Instant expireAt, ExpirationOptions options) {
            super(key);
            this.expireAt = expireAt;
            this.options = options;
        }

        public static ExpireAtCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new ExpireAtCommand(key, null);
        }

        public ExpireAtCommand timeout(Instant expireAt) {
            Assert.notNull((Object)expireAt, (String)"Expire at must not be null");
            return new ExpireAtCommand(this.getKey(), expireAt);
        }

        public ExpireAtCommand withOptions(ExpirationOptions options) {
            return new ExpireAtCommand(this.getKey(), this.getExpireAt(), options);
        }

        public @Nullable Instant getExpireAt() {
            return this.expireAt;
        }

        public ExpirationOptions getOptions() {
            return this.options;
        }
    }

    public static class MoveCommand
    extends ReactiveRedisConnection.KeyCommand {
        private @Nullable Integer database;

        private MoveCommand(@Nullable ByteBuffer key, @Nullable Integer database) {
            super(key);
            this.database = database;
        }

        public static MoveCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new MoveCommand(key, null);
        }

        public MoveCommand timeout(int database) {
            return new MoveCommand(this.getKey(), database);
        }

        public @Nullable Integer getDatabase() {
            return this.database;
        }
    }
}

