/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.support.collections.DefaultRedisZSet;
import org.springframework.data.redis.support.collections.RedisCollection;

public interface RedisZSet<E>
extends RedisCollection<E>,
Set<E> {
    public static <E> RedisZSet<E> create(String key, RedisOperations<String, E> operations) {
        return new DefaultRedisZSet<E>(key, operations, 1.0);
    }

    public static <E> RedisZSet<E> create(String key, RedisOperations<String, E> operations, double defaultScore) {
        return new DefaultRedisZSet<E>(key, operations, defaultScore);
    }

    public Set<E> diff(RedisZSet<?> var1);

    public Set<E> diff(Collection<? extends RedisZSet<?>> var1);

    public Set<ZSetOperations.TypedTuple<E>> diffWithScores(RedisZSet<?> var1);

    public Set<ZSetOperations.TypedTuple<E>> diffWithScores(Collection<? extends RedisZSet<?>> var1);

    public RedisZSet<E> diffAndStore(RedisZSet<?> var1, String var2);

    public RedisZSet<E> diffAndStore(Collection<? extends RedisZSet<?>> var1, String var2);

    public Set<E> intersect(RedisZSet<?> var1);

    public Set<E> intersect(Collection<? extends RedisZSet<?>> var1);

    public Set<ZSetOperations.TypedTuple<E>> intersectWithScores(RedisZSet<?> var1);

    public Set<ZSetOperations.TypedTuple<E>> intersectWithScores(Collection<? extends RedisZSet<?>> var1);

    public RedisZSet<E> intersectAndStore(RedisZSet<?> var1, String var2);

    public RedisZSet<E> intersectAndStore(Collection<? extends RedisZSet<?>> var1, String var2);

    public Set<E> union(RedisZSet<?> var1);

    public Set<E> union(Collection<? extends RedisZSet<?>> var1);

    public Set<ZSetOperations.TypedTuple<E>> unionWithScores(RedisZSet<?> var1);

    public Set<ZSetOperations.TypedTuple<E>> unionWithScores(Collection<? extends RedisZSet<?>> var1);

    public RedisZSet<E> unionAndStore(RedisZSet<?> var1, String var2);

    public RedisZSet<E> unionAndStore(Collection<? extends RedisZSet<?>> var1, String var2);

    public E randomValue();

    public Set<E> range(long var1, long var3);

    public Set<E> reverseRange(long var1, long var3);

    @Deprecated(since="3.0", forRemoval=true)
    default public Set<E> rangeByLex(RedisZSetCommands.Range range) {
        return this.rangeByLex(range.toRange());
    }

    default public Set<E> rangeByLex(Range<String> range) {
        return this.rangeByLex(range, Limit.unlimited());
    }

    @Deprecated(since="3.0", forRemoval=true)
    default public Set<E> rangeByLex(RedisZSetCommands.Range range, Limit limit) {
        return this.rangeByLex(range.toRange(), limit);
    }

    public Set<E> rangeByLex(Range<String> var1, Limit var2);

    @Deprecated(since="3.0", forRemoval=true)
    default public Set<E> reverseRangeByLex(RedisZSetCommands.Range range) {
        return this.reverseRangeByLex(range.toRange());
    }

    default public Set<E> reverseRangeByLex(Range<String> range) {
        return this.reverseRangeByLex(range, Limit.unlimited());
    }

    @Deprecated(since="3.0", forRemoval=true)
    default public Set<E> reverseRangeByLex(RedisZSetCommands.Range range, Limit limit) {
        return this.reverseRangeByLex(range.toRange(), limit);
    }

    public Set<E> reverseRangeByLex(Range<String> var1, Limit var2);

    public Set<E> rangeByScore(double var1, double var3);

    public Set<E> reverseRangeByScore(double var1, double var3);

    public Set<ZSetOperations.TypedTuple<E>> rangeWithScores(long var1, long var3);

    public Set<ZSetOperations.TypedTuple<E>> reverseRangeWithScores(long var1, long var3);

    public Set<ZSetOperations.TypedTuple<E>> rangeByScoreWithScores(double var1, double var3);

    public Set<ZSetOperations.TypedTuple<E>> reverseRangeByScoreWithScores(double var1, double var3);

    default public RedisZSet<E> rangeAndStoreByLex(String dstKey, Range<String> range) {
        return this.rangeAndStoreByLex(dstKey, range, Limit.unlimited());
    }

    public RedisZSet<E> rangeAndStoreByLex(String var1, Range<String> var2, Limit var3);

    default public RedisZSet<E> reverseRangeAndStoreByLex(String dstKey, Range<String> range) {
        return this.reverseRangeAndStoreByLex(dstKey, range, Limit.unlimited());
    }

    public RedisZSet<E> reverseRangeAndStoreByLex(String var1, Range<String> var2, Limit var3);

    default public RedisZSet<E> rangeAndStoreByScore(String dstKey, Range<? extends Number> range) {
        return this.rangeAndStoreByScore(dstKey, range, Limit.unlimited());
    }

    public RedisZSet<E> rangeAndStoreByScore(String var1, Range<? extends Number> var2, Limit var3);

    default public RedisZSet<E> reverseRangeAndStoreByScore(String dstKey, Range<? extends Number> range) {
        return this.reverseRangeAndStoreByScore(dstKey, range, Limit.unlimited());
    }

    public RedisZSet<E> reverseRangeAndStoreByScore(String var1, Range<? extends Number> var2, Limit var3);

    public RedisZSet<E> remove(long var1, long var3);

    public RedisZSet<E> removeByLex(Range<String> var1);

    public RedisZSet<E> removeByScore(double var1, double var3);

    public boolean add(E var1, double var2);

    @Override
    public boolean add(E var1);

    default public boolean addIfAbsent(E e) {
        return this.addIfAbsent(e, this.getDefaultScore());
    }

    public boolean addIfAbsent(E var1, double var2);

    public Long lexCount(Range<String> var1);

    public Double score(Object var1);

    public Long rank(Object var1);

    public Long reverseRank(Object var1);

    public Double getDefaultScore();

    public E first();

    public E popFirst();

    public E popFirst(long var1, TimeUnit var3);

    public E last();

    public E popLast();

    public E popLast(long var1, TimeUnit var3);

    public Iterator<E> scan();
}

