/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DefaultedRedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;

class DefaultValueOperations<K, V>
extends AbstractOperations<K, V>
implements ValueOperations<K, V> {
    DefaultValueOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public V get(Object key) {
        return (V)this.execute(this.valueCallbackFor(key, DefaultedRedisConnection::get));
    }

    @Override
    @Nullable
    public V getAndDelete(K key) {
        return (V)this.execute(this.valueCallbackFor(key, DefaultedRedisConnection::getDel));
    }

    @Override
    @Nullable
    public V getAndExpire(K key, long timeout, TimeUnit unit) {
        return (V)this.execute(this.valueCallbackFor(key, (connection, rawKey) -> connection.getEx((byte[])rawKey, Expiration.from(timeout, unit))));
    }

    @Override
    @Nullable
    public V getAndExpire(K key, Duration timeout) {
        return (V)this.execute(this.valueCallbackFor(key, (connection, rawKey) -> connection.getEx((byte[])rawKey, Expiration.from(timeout))));
    }

    @Override
    @Nullable
    public V getAndPersist(K key) {
        return (V)this.execute(this.valueCallbackFor(key, (connection, rawKey) -> connection.getEx((byte[])rawKey, Expiration.persistent())));
    }

    @Override
    public V getAndSet(K key, V newValue) {
        byte[] rawValue = this.rawValue(newValue);
        return (V)this.execute(this.valueCallbackFor(key, (connection, rawKey) -> connection.getSet((byte[])rawKey, rawValue)));
    }

    @Override
    public Long increment(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.incr(rawKey));
    }

    @Override
    public Long increment(K key, long delta) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.incrBy(rawKey, delta));
    }

    @Override
    public Double increment(K key, double delta) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.incrBy(rawKey, delta));
    }

    @Override
    public Long decrement(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.decr(rawKey));
    }

    @Override
    public Long decrement(K key, long delta) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.decrBy(rawKey, delta));
    }

    @Override
    public Integer append(K key, String value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawString = this.rawString(value);
        return this.execute(connection -> {
            Long result = connection.append(rawKey, rawString);
            return result != null ? Integer.valueOf(result.intValue()) : null;
        });
    }

    @Override
    public String get(K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawReturn = this.execute(connection -> connection.getRange(rawKey, start, end));
        return this.deserializeString(rawReturn);
    }

    @Override
    public List<V> multiGet(Collection<K> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        byte[][] rawKeys = new byte[keys.size()][];
        int counter = 0;
        for (K hashKey : keys) {
            rawKeys[counter++] = this.rawKey(hashKey);
        }
        List rawValues = this.execute(connection -> connection.mGet(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public void multiSet(Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return;
        }
        LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(entry.getKey()), this.rawValue(entry.getValue()));
        }
        this.execute(connection -> {
            connection.mSet(rawKeys);
            return null;
        });
    }

    @Override
    public Boolean multiSetIfAbsent(Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return true;
        }
        LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(entry.getKey()), this.rawValue(entry.getValue()));
        }
        return this.execute(connection -> connection.mSetNX(rawKeys));
    }

    @Override
    public void set(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        this.execute(connection -> connection.set(rawKey, rawValue));
    }

    @Override
    public void set(K key, V value, long timeout, TimeUnit unit) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        this.execute(connection -> connection.set(rawKey, rawValue, Expiration.from(timeout, unit), RedisStringCommands.SetOption.upsert()));
    }

    @Override
    public Boolean setIfAbsent(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.set(rawKey, rawValue, Expiration.persistent(), RedisStringCommands.SetOption.ifAbsent()));
    }

    @Override
    public Boolean setIfAbsent(K key, V value, long timeout, TimeUnit unit) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        Expiration expiration = Expiration.from(timeout, unit);
        return this.execute(connection -> connection.set(rawKey, rawValue, expiration, RedisStringCommands.SetOption.ifAbsent()));
    }

    @Override
    @Nullable
    public Boolean setIfPresent(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.set(rawKey, rawValue, Expiration.persistent(), RedisStringCommands.SetOption.ifPresent()));
    }

    @Override
    @Nullable
    public Boolean setIfPresent(K key, V value, long timeout, TimeUnit unit) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        Expiration expiration = Expiration.from(timeout, unit);
        return this.execute(connection -> connection.set(rawKey, rawValue, expiration, RedisStringCommands.SetOption.ifPresent()));
    }

    @Override
    public void set(K key, V value, long offset) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        this.execute(connection -> {
            connection.setRange(rawKey, rawValue, offset);
            return null;
        });
    }

    @Override
    public Long size(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.strLen(rawKey));
    }

    @Override
    public Boolean setBit(K key, long offset, boolean value) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.setBit(rawKey, offset, value));
    }

    @Override
    public Boolean getBit(K key, long offset) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.getBit(rawKey, offset));
    }

    @Override
    public List<Long> bitField(K key, BitFieldSubCommands subCommands) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.bitField(rawKey, subCommands));
    }
}

