/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.stream;

import java.util.Optional;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.ReadOffset;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ReadOffsetStrategy {
    NextMessage{

        @Override
        public ReadOffset getFirst(ReadOffset readOffset, Optional<Consumer> consumer) {
            return readOffset;
        }

        @Override
        public ReadOffset getNext(ReadOffset readOffset, Optional<Consumer> consumer, String lastConsumedMessageId) {
            return ReadOffset.from(lastConsumedMessageId);
        }
    }
    ,
    LastConsumed{

        @Override
        public ReadOffset getFirst(ReadOffset readOffset, Optional<Consumer> consumer) {
            return consumer.map(it -> ReadOffset.lastConsumed()).orElseGet(ReadOffset::latest);
        }

        @Override
        public ReadOffset getNext(ReadOffset readOffset, Optional<Consumer> consumer, String lastConsumedMessageId) {
            return consumer.map(it -> ReadOffset.lastConsumed()).orElseGet(() -> ReadOffset.from(lastConsumedMessageId));
        }
    }
    ,
    Latest{

        @Override
        public ReadOffset getFirst(ReadOffset readOffset, Optional<Consumer> consumer) {
            return ReadOffset.latest();
        }

        @Override
        public ReadOffset getNext(ReadOffset readOffset, Optional<Consumer> consumer, String lastConsumedMessageId) {
            return ReadOffset.latest();
        }
    };


    static ReadOffsetStrategy getStrategy(ReadOffset offset) {
        if (ReadOffset.latest().equals(offset)) {
            return Latest;
        }
        if (ReadOffset.lastConsumed().equals(offset)) {
            return LastConsumed;
        }
        return NextMessage;
    }

    public abstract ReadOffset getFirst(ReadOffset var1, Optional<Consumer> var2);

    public abstract ReadOffset getNext(ReadOffset var1, Optional<Consumer> var2, String var3);
}

