/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public enum ReturnType {
    BOOLEAN,
    INTEGER,
    MULTI,
    STATUS,
    VALUE;


    public static ReturnType fromJavaType(@Nullable Class<?> javaType) {
        if (javaType == null) {
            return STATUS;
        }
        if (ClassUtils.isAssignable(List.class, javaType)) {
            return MULTI;
        }
        if (ClassUtils.isAssignable(Boolean.class, javaType)) {
            return BOOLEAN;
        }
        if (ClassUtils.isAssignable(Long.class, javaType)) {
            return INTEGER;
        }
        return VALUE;
    }
}

