/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterStringCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveStringCommands;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveClusterStringCommands
extends LettuceReactiveStringCommands
implements ReactiveClusterStringCommands {
    LettuceReactiveClusterStringCommands(LettuceReactiveRedisConnection connection) {
        super(connection);
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>> bitOp(Publisher<ReactiveStringCommands.BitOpCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getKeys());
            keys.add(command.getDestinationKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
                return super.bitOp((Publisher<ReactiveStringCommands.BitOpCommand>)Mono.just((Object)command));
            }
            return Mono.error((Throwable)new InvalidDataAccessApiUsageException("All keys must map to the same slot for BITOP command."));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSetNX(Publisher<ReactiveStringCommands.MSetCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeyValuePairs().keySet())) {
                return super.mSetNX((Publisher<ReactiveStringCommands.MSetCommand>)Mono.just((Object)command));
            }
            return Mono.error((Throwable)new InvalidDataAccessApiUsageException("All keys must map to the same slot for MSETNX command."));
        }));
    }
}

