/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.AuthenticatingRedisClient;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.util.Assert;

public class LettuceConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(LettuceConverters.exceptionConverter());
    private final Log log = LogFactory.getLog(this.getClass());
    private String hostName = "localhost";
    private int port = 6379;
    private RedisClient client;
    private long timeout = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private boolean validateConnection = false;
    private boolean shareNativeConnection = true;
    private RedisAsyncConnection<byte[], byte[]> connection;
    private LettucePool pool;
    private int dbIndex = 0;
    private final Object connectionMonitor = new Object();
    private String password;
    private boolean convertPipelineAndTxResults = true;

    public LettuceConnectionFactory() {
    }

    public LettuceConnectionFactory(String host, int port) {
        this.hostName = host;
        this.port = port;
    }

    public LettuceConnectionFactory(LettucePool pool) {
        this.pool = pool;
    }

    public void afterPropertiesSet() {
        this.client = this.createRedisClient();
    }

    public void destroy() {
        this.resetConnection();
        this.client.shutdown();
    }

    @Override
    public RedisConnection getConnection() {
        LettuceConnection connection = new LettuceConnection(this.getSharedConnection(), this.timeout, this.client, this.pool);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.resetConnection();
            }
            this.connection = this.createLettuceConnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            try {
                new com.lambdaworks.redis.RedisConnection(this.connection).ping();
            }
            catch (RedisException e) {
                this.log.warn((Object)"Validation of shared connection failed. Creating a new connection.");
                this.initConnection();
            }
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean getValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public boolean getShareNativeConnection() {
        return this.shareNativeConnection;
    }

    public void setShareNativeConnection(boolean shareNativeConnection) {
        this.shareNativeConnection = shareNativeConnection;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RedisAsyncConnection<byte[], byte[]> getSharedConnection() {
        if (this.shareNativeConnection) {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.connection == null) {
                    this.initConnection();
                }
                if (this.validateConnection) {
                    this.validateConnection();
                }
                return this.connection;
            }
        }
        return null;
    }

    protected RedisAsyncConnection<byte[], byte[]> createLettuceConnector() {
        try {
            RedisAsyncConnection connection = this.client.connectAsync(LettuceConnection.CODEC);
            if (this.dbIndex > 0) {
                connection.select(this.dbIndex);
            }
            return connection;
        }
        catch (RedisException e) {
            throw new RedisConnectionFailureException("Unable to connect to Redis on " + this.getHostName() + ":" + this.getPort(), e);
        }
    }

    private RedisClient createRedisClient() {
        if (this.pool != null) {
            return this.pool.getClient();
        }
        AuthenticatingRedisClient client = this.password != null ? new AuthenticatingRedisClient(this.hostName, this.port, this.password) : new RedisClient(this.hostName, this.port);
        client.setDefaultTimeout(this.timeout, TimeUnit.MILLISECONDS);
        return client;
    }
}

