/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ValueOperations;

class DefaultValueOperations<K, V>
extends AbstractOperations<K, V>
implements ValueOperations<K, V> {
    DefaultValueOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public V get(Object key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.get(rawKey);
            }
        }, true);
    }

    @Override
    public V getAndSet(K key, V newValue) {
        final byte[] rawValue = this.rawValue(newValue);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.getSet(rawKey, rawValue);
            }
        }, true);
    }

    @Override
    public Long increment(K key, final long delta) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.incrBy(rawKey, delta);
            }
        }, true);
    }

    @Override
    public Double increment(K key, final double delta) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Double>(){

            @Override
            public Double doInRedis(RedisConnection connection) {
                return connection.incrBy(rawKey, delta);
            }
        }, true);
    }

    @Override
    public Integer append(K key, String value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawString = this.rawString(value);
        return this.execute(new RedisCallback<Integer>(){

            @Override
            public Integer doInRedis(RedisConnection connection) {
                Long result = connection.append(rawKey, rawString);
                return result != null ? Integer.valueOf(result.intValue()) : null;
            }
        }, true);
    }

    @Override
    public String get(K key, final long start, final long end) {
        final byte[] rawKey = this.rawKey(key);
        byte[] rawReturn = this.execute(new RedisCallback<byte[]>(){

            @Override
            public byte[] doInRedis(RedisConnection connection) {
                return connection.getRange(rawKey, start, end);
            }
        }, true);
        return this.deserializeString(rawReturn);
    }

    @Override
    public List<V> multiGet(Collection<K> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        final byte[][] rawKeys = new byte[keys.size()][];
        int counter = 0;
        for (K hashKey : keys) {
            rawKeys[counter++] = this.rawKey(hashKey);
        }
        List<byte[]> rawValues = this.execute(new RedisCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInRedis(RedisConnection connection) {
                return connection.mGet(rawKeys);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public void multiSet(Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(entry.getKey()), this.rawValue(entry.getValue()));
        }
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.mSet(rawKeys);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean multiSetIfAbsent(Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return true;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(entry.getKey()), this.rawValue(entry.getValue()));
        }
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.mSetNX(rawKeys);
            }
        }, true);
    }

    @Override
    public void set(K key, V value) {
        final byte[] rawValue = this.rawValue(value);
        this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                connection.set(rawKey, rawValue);
                return null;
            }
        }, true);
    }

    @Override
    public void set(K key, V value, long timeout, TimeUnit unit) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        final long rawTimeout = TimeoutUtils.toSeconds(timeout, unit);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(rawKey, rawTimeout, rawValue);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean setIfAbsent(K key, V value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.setNX(rawKey, rawValue);
            }
        }, true);
    }

    @Override
    public void set(K key, V value, final long offset) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.setRange(rawKey, rawValue, offset);
                return null;
            }
        }, true);
    }

    @Override
    public Long size(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.strLen(rawKey);
            }
        }, true);
    }
}

