/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.DefaultStringTuple;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.convert.MapConverter;
import org.springframework.data.redis.connection.convert.SetConverter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;

public class DefaultStringRedisConnection
implements StringRedisConnection {
    private final Log log = LogFactory.getLog(DefaultStringRedisConnection.class);
    private final RedisConnection delegate;
    private final RedisSerializer<String> serializer;
    private Converter<byte[], String> bytesToString = new DeserializingConverter();
    private SetConverter<RedisZSetCommands.Tuple, StringRedisConnection.StringTuple> tupleToStringTuple = new SetConverter<RedisZSetCommands.Tuple, StringRedisConnection.StringTuple>(new TupleConverter());
    private SetConverter<StringRedisConnection.StringTuple, RedisZSetCommands.Tuple> stringTupleToTuple = new SetConverter<StringRedisConnection.StringTuple, RedisZSetCommands.Tuple>(new StringTupleConverter());
    private ListConverter<byte[], String> byteListToStringList = new ListConverter<byte[], String>(this.bytesToString);
    private MapConverter<byte[], String> byteMapToStringMap = new MapConverter<byte[], String>(this.bytesToString);
    private SetConverter<byte[], String> byteSetToStringSet = new SetConverter<byte[], String>(this.bytesToString);
    private Queue<Converter> pipelineConverters = new LinkedList<Converter>();
    private Queue<Converter> txConverters = new LinkedList<Converter>();
    private boolean deserializePipelineAndTxResults = false;
    private IdentityConverter identityConverter = new IdentityConverter();

    public DefaultStringRedisConnection(RedisConnection connection) {
        Assert.notNull((Object)connection, (String)"connection is required");
        this.delegate = connection;
        this.serializer = new StringRedisSerializer();
    }

    public DefaultStringRedisConnection(RedisConnection connection, RedisSerializer<String> serializer) {
        Assert.notNull((Object)connection, (String)"connection is required");
        Assert.notNull((Object)connection, (String)"serializer is required");
        this.delegate = connection;
        this.serializer = serializer;
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Long result = this.delegate.append(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void bgSave() {
        this.delegate.bgSave();
    }

    @Override
    public void bgWriteAof() {
        this.delegate.bgWriteAof();
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        List<byte[]> results = this.delegate.bLPop(timeout, keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        List<byte[]> results = this.delegate.bRPop(timeout, keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        byte[] result = this.delegate.bRPopLPush(timeout, srcKey, dstKey);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void close() throws RedisSystemException {
        this.delegate.close();
    }

    @Override
    public Long dbSize() {
        Long result = this.delegate.dbSize();
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long decr(byte[] key) {
        Long result = this.delegate.decr(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        Long result = this.delegate.decrBy(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long del(byte[] ... keys) {
        Long result = this.delegate.del(keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard() {
        try {
            this.delegate.discard();
        }
        finally {
            this.txConverters.clear();
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        byte[] result = this.delegate.echo(message);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> exec() {
        try {
            List<Object> results = this.delegate.exec();
            if (this.isPipelined()) {
                this.pipelineConverters.add(new TransactionResultConverter(new LinkedList<Converter>(this.txConverters)));
                List<Object> list = results;
                return list;
            }
            List<Object> list = this.convertResults(results, this.txConverters);
            return list;
        }
        finally {
            this.txConverters.clear();
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        Boolean result = this.delegate.exists(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        Boolean result = this.delegate.expire(key, seconds);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        Boolean result = this.delegate.expireAt(key, unixTime);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void flushAll() {
        this.delegate.flushAll();
    }

    @Override
    public void flushDb() {
        this.delegate.flushDb();
    }

    @Override
    public byte[] get(byte[] key) {
        byte[] result = this.delegate.get(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        Boolean result = this.delegate.getBit(key, offset);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<String> getConfig(String pattern) {
        List<String> results = this.delegate.getConfig(pattern);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Object getNativeConnection() {
        Object result = this.delegate.getNativeConnection();
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        byte[] result = this.delegate.getRange(key, start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        byte[] result = this.delegate.getSet(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Subscription getSubscription() {
        return this.delegate.getSubscription();
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Long result = this.delegate.hDel(key, fields);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Boolean result = this.delegate.hExists(key, field);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        byte[] result = this.delegate.hGet(key, field);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Map<byte[], byte[]> results = this.delegate.hGetAll(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Long result = this.delegate.hIncrBy(key, field, delta);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Double result = this.delegate.hIncrBy(key, field, delta);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Set<byte[]> results = this.delegate.hKeys(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long hLen(byte[] key) {
        Long result = this.delegate.hLen(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        List<byte[]> results = this.delegate.hMGet(key, fields);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        this.delegate.hMSet(key, hashes);
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Boolean result = this.delegate.hSet(key, field, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Boolean result = this.delegate.hSetNX(key, field, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        List<byte[]> results = this.delegate.hVals(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long incr(byte[] key) {
        Long result = this.delegate.incr(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        Long result = this.delegate.incrBy(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        Double result = this.delegate.incrBy(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Properties info() {
        Properties result = this.delegate.info();
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Properties info(String section) {
        Properties result = this.delegate.info(section);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isQueueing() {
        return this.delegate.isQueueing();
    }

    @Override
    public boolean isSubscribed() {
        return this.delegate.isSubscribed();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Set<byte[]> results = this.delegate.keys(pattern);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long lastSave() {
        Long result = this.delegate.lastSave();
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        byte[] result = this.delegate.lIndex(key, index);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        Long result = this.delegate.lInsert(key, where, pivot, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long lLen(byte[] key) {
        Long result = this.delegate.lLen(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] lPop(byte[] key) {
        byte[] result = this.delegate.lPop(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        Long result = this.delegate.lPush(key, values);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        Long result = this.delegate.lPushX(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        List<byte[]> results = this.delegate.lRange(key, start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        Long result = this.delegate.lRem(key, count, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        this.delegate.lSet(key, index, value);
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        this.delegate.lTrim(key, start, end);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        List<byte[]> results = this.delegate.mGet(keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuple) {
        this.delegate.mSet(tuple);
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        Boolean result = this.delegate.mSetNX(tuple);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void multi() {
        this.delegate.multi();
    }

    @Override
    public Boolean persist(byte[] key) {
        Boolean result = this.delegate.persist(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        Boolean result = this.delegate.move(key, dbIndex);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public String ping() {
        String result = this.delegate.ping();
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.delegate.pSubscribe(listener, patterns);
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        Long result = this.delegate.publish(channel, message);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] randomKey() {
        byte[] result = this.delegate.randomKey();
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        this.delegate.rename(oldName, newName);
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        Boolean result = this.delegate.renameNX(oldName, newName);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void resetConfigStats() {
        this.delegate.resetConfigStats();
    }

    @Override
    public byte[] rPop(byte[] key) {
        byte[] result = this.delegate.rPop(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        byte[] result = this.delegate.rPopLPush(srcKey, dstKey);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        Long result = this.delegate.rPush(key, values);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        Long result = this.delegate.rPushX(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        Long result = this.delegate.sAdd(key, values);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void save() {
        this.delegate.save();
    }

    @Override
    public Long sCard(byte[] key) {
        Long result = this.delegate.sCard(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        Set<byte[]> results = this.delegate.sDiff(keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        Long result = this.delegate.sDiffStore(destKey, keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void select(int dbIndex) {
        this.delegate.select(dbIndex);
    }

    @Override
    public void set(byte[] key, byte[] value) {
        this.delegate.set(key, value);
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        this.delegate.setBit(key, offset, value);
    }

    @Override
    public void setConfig(String param, String value) {
        this.delegate.setConfig(param, value);
    }

    @Override
    public void setEx(byte[] key, long seconds, byte[] value) {
        this.delegate.setEx(key, seconds, value);
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        Boolean result = this.delegate.setNX(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        this.delegate.setRange(key, value, start);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        Set<byte[]> results = this.delegate.sInter(keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        Long result = this.delegate.sInterStore(destKey, keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        Boolean result = this.delegate.sIsMember(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        Set<byte[]> results = this.delegate.sMembers(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        Boolean result = this.delegate.sMove(srcKey, destKey, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        Long result = this.delegate.sort(key, params, storeKey);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        List<byte[]> results = this.delegate.sort(key, params);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public byte[] sPop(byte[] key) {
        byte[] result = this.delegate.sPop(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        byte[] result = this.delegate.sRandMember(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        List<byte[]> results = this.delegate.sRandMember(key, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        Long result = this.delegate.sRem(key, values);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long strLen(byte[] key) {
        Long result = this.delegate.strLen(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long bitCount(byte[] key) {
        Long result = this.delegate.bitCount(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        Long result = this.delegate.bitCount(key, begin, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        Long result = this.delegate.bitOp(op, destination, keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.delegate.subscribe(listener, channels);
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        Set<byte[]> results = this.delegate.sUnion(keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        Long result = this.delegate.sUnionStore(destKey, keys);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long ttl(byte[] key) {
        Long result = this.delegate.ttl(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public DataType type(byte[] key) {
        DataType result = this.delegate.type(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void unwatch() {
        this.delegate.unwatch();
    }

    @Override
    public void watch(byte[] ... keys) {
        this.delegate.watch(keys);
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        Boolean result = this.delegate.zAdd(key, score, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        Long result = this.delegate.zAdd(key, tuples);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zCard(byte[] key) {
        Long result = this.delegate.zCard(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        Long result = this.delegate.zCount(key, min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Double result = this.delegate.zIncrBy(key, increment, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Long result = this.delegate.zInterStore(destKey, aggregate, weights, sets);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Long result = this.delegate.zInterStore(destKey, sets);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Set<byte[]> results = this.delegate.zRange(key, start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        Set<byte[]> results = this.delegate.zRangeByScore(key, min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        Set<byte[]> results = this.delegate.zRangeByScore(key, min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRangeByScoreWithScores(key, min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRangeByScoreWithScores(key, min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRangeWithScores(key, start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        Set<byte[]> results = this.delegate.zRevRangeByScore(key, min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        Set<byte[]> results = this.delegate.zRevRangeByScore(key, min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRevRangeByScoreWithScores(key, min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRevRangeByScoreWithScores(key, min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Long result = this.delegate.zRank(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Long result = this.delegate.zRem(key, values);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Long result = this.delegate.zRemRange(key, start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        Long result = this.delegate.zRemRangeByScore(key, min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Set<byte[]> results = this.delegate.zRevRange(key, start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRevRangeWithScores(key, start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Long result = this.delegate.zRevRank(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Double result = this.delegate.zScore(key, value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Long result = this.delegate.zUnionStore(destKey, aggregate, weights, sets);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Long result = this.delegate.zUnionStore(destKey, sets);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        Boolean result = this.delegate.pExpire(key, millis);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        Boolean result = this.delegate.pExpireAt(key, unixTimeInMillis);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long pTtl(byte[] key) {
        Long result = this.delegate.pTtl(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public byte[] dump(byte[] key) {
        byte[] result = this.delegate.dump(key);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.delegate.restore(key, ttlInMillis, serializedValue);
    }

    @Override
    public void scriptFlush() {
        this.delegate.scriptFlush();
    }

    @Override
    public void scriptKill() {
        this.delegate.scriptKill();
    }

    @Override
    public String scriptLoad(byte[] script) {
        String result = this.delegate.scriptLoad(script);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        List<Boolean> results = this.delegate.scriptExists(scriptSha1);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Object result = this.delegate.eval(script, returnType, numKeys, keysAndArgs);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Object result = this.delegate.evalSha(scriptSha1, returnType, numKeys, keysAndArgs);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    private byte[] serialize(String data) {
        return this.serializer.serialize(data);
    }

    private byte[][] serializeMulti(String ... keys) {
        byte[][] ret = new byte[keys.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.serializer.serialize(keys[i]);
        }
        return ret;
    }

    private Map<byte[], byte[]> serialize(Map<String, String> hashes) {
        LinkedHashMap<byte[], byte[]> ret = new LinkedHashMap<byte[], byte[]>(hashes.size());
        for (Map.Entry<String, String> entry : hashes.entrySet()) {
            ret.put(this.serializer.serialize(entry.getKey()), this.serializer.serialize(entry.getValue()));
        }
        return ret;
    }

    @Override
    public Long append(String key, String value) {
        Long result = this.delegate.append(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<String> bLPop(int timeout, String ... keys) {
        List<byte[]> results = this.delegate.bLPop(timeout, this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public List<String> bRPop(int timeout, String ... keys) {
        List<byte[]> results = this.delegate.bRPop(timeout, this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public String bRPopLPush(int timeout, String srcKey, String dstKey) {
        byte[] result = this.delegate.bRPopLPush(timeout, this.serialize(srcKey), this.serialize(dstKey));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Long decr(String key) {
        Long result = this.delegate.decr(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long decrBy(String key, long value) {
        Long result = this.delegate.decrBy(this.serialize(key), value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long del(String ... keys) {
        Long result = this.delegate.del(this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public String echo(String message) {
        byte[] result = this.delegate.echo(this.serialize(message));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Boolean exists(String key) {
        Boolean result = this.delegate.exists(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean expire(String key, long seconds) {
        Boolean result = this.delegate.expire(this.serialize(key), seconds);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean expireAt(String key, long unixTime) {
        Boolean result = this.delegate.expireAt(this.serialize(key), unixTime);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public String get(String key) {
        byte[] result = this.delegate.get(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Boolean getBit(String key, long offset) {
        Boolean result = this.delegate.getBit(this.serialize(key), offset);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public String getRange(String key, long start, long end) {
        byte[] result = this.delegate.getRange(this.serialize(key), start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public String getSet(String key, String value) {
        byte[] result = this.delegate.getSet(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Long hDel(String key, String ... fields) {
        Long result = this.delegate.hDel(this.serialize(key), this.serializeMulti(fields));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean hExists(String key, String field) {
        Boolean result = this.delegate.hExists(this.serialize(key), this.serialize(field));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public String hGet(String key, String field) {
        byte[] result = this.delegate.hGet(this.serialize(key), this.serialize(field));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Map<String, String> hGetAll(String key) {
        Map<byte[], byte[]> results = this.delegate.hGetAll(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteMapToStringMap);
        }
        return this.byteMapToStringMap.convert(results);
    }

    @Override
    public Long hIncrBy(String key, String field, long delta) {
        Long result = this.delegate.hIncrBy(this.serialize(key), this.serialize(field), delta);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double hIncrBy(String key, String field, double delta) {
        Double result = this.delegate.hIncrBy(this.serialize(key), this.serialize(field), delta);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<String> hKeys(String key) {
        Set<byte[]> results = this.delegate.hKeys(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Long hLen(String key) {
        Long result = this.delegate.hLen(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<String> hMGet(String key, String ... fields) {
        List<byte[]> results = this.delegate.hMGet(this.serialize(key), this.serializeMulti(fields));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public void hMSet(String key, Map<String, String> hashes) {
        this.delegate.hMSet(this.serialize(key), this.serialize(hashes));
    }

    @Override
    public Boolean hSet(String key, String field, String value) {
        Boolean result = this.delegate.hSet(this.serialize(key), this.serialize(field), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean hSetNX(String key, String field, String value) {
        Boolean result = this.delegate.hSetNX(this.serialize(key), this.serialize(field), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<String> hVals(String key) {
        List<byte[]> results = this.delegate.hVals(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public Long incr(String key) {
        Long result = this.delegate.incr(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long incrBy(String key, long value) {
        Long result = this.delegate.incrBy(this.serialize(key), value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double incrBy(String key, double value) {
        Double result = this.delegate.incrBy(this.serialize(key), value);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Collection<String> keys(String pattern) {
        Set<byte[]> results = this.delegate.keys(this.serialize(pattern));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public String lIndex(String key, long index) {
        byte[] result = this.delegate.lIndex(this.serialize(key), index);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Long lInsert(String key, RedisListCommands.Position where, String pivot, String value) {
        Long result = this.delegate.lInsert(this.serialize(key), where, this.serialize(pivot), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long lLen(String key) {
        Long result = this.delegate.lLen(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public String lPop(String key) {
        byte[] result = this.delegate.lPop(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Long lPush(String key, String ... values) {
        Long result = this.delegate.lPush(this.serialize(key), this.serializeMulti(values));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long lPushX(String key, String value) {
        Long result = this.delegate.lPushX(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<String> lRange(String key, long start, long end) {
        List<byte[]> results = this.delegate.lRange(this.serialize(key), start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public Long lRem(String key, long count, String value) {
        Long result = this.delegate.lRem(this.serialize(key), count, this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void lSet(String key, long index, String value) {
        this.delegate.lSet(this.serialize(key), index, this.serialize(value));
    }

    @Override
    public void lTrim(String key, long start, long end) {
        this.delegate.lTrim(this.serialize(key), start, end);
    }

    @Override
    public List<String> mGet(String ... keys) {
        List<byte[]> results = this.delegate.mGet(this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public Boolean mSetNXString(Map<String, String> tuple) {
        Boolean result = this.delegate.mSetNX(this.serialize(tuple));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void mSetString(Map<String, String> tuple) {
        this.delegate.mSet(this.serialize(tuple));
    }

    @Override
    public Boolean persist(String key) {
        Boolean result = this.delegate.persist(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean move(String key, int dbIndex) {
        Boolean result = this.delegate.move(this.serialize(key), dbIndex);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void pSubscribe(MessageListener listener, String ... patterns) {
        this.delegate.pSubscribe(listener, this.serializeMulti(patterns));
    }

    @Override
    public Long publish(String channel, String message) {
        Long result = this.delegate.publish(this.serialize(channel), this.serialize(message));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void rename(String oldName, String newName) {
        this.delegate.rename(this.serialize(oldName), this.serialize(newName));
    }

    @Override
    public Boolean renameNX(String oldName, String newName) {
        Boolean result = this.delegate.renameNX(this.serialize(oldName), this.serialize(newName));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public String rPop(String key) {
        byte[] result = this.delegate.rPop(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public String rPopLPush(String srcKey, String dstKey) {
        byte[] result = this.delegate.rPopLPush(this.serialize(srcKey), this.serialize(dstKey));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public Long rPush(String key, String ... values) {
        Long result = this.delegate.rPush(this.serialize(key), this.serializeMulti(values));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long rPushX(String key, String value) {
        Long result = this.delegate.rPushX(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long sAdd(String key, String ... values) {
        Long result = this.delegate.sAdd(this.serialize(key), this.serializeMulti(values));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long sCard(String key) {
        Long result = this.delegate.sCard(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<String> sDiff(String ... keys) {
        Set<byte[]> results = this.delegate.sDiff(this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Long sDiffStore(String destKey, String ... keys) {
        Long result = this.delegate.sDiffStore(this.serialize(destKey), this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void set(String key, String value) {
        this.delegate.set(this.serialize(key), this.serialize(value));
    }

    @Override
    public void setBit(String key, long offset, boolean value) {
        this.delegate.setBit(this.serialize(key), offset, value);
    }

    @Override
    public void setEx(String key, long seconds, String value) {
        this.delegate.setEx(this.serialize(key), seconds, this.serialize(value));
    }

    @Override
    public Boolean setNX(String key, String value) {
        Boolean result = this.delegate.setNX(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void setRange(String key, String value, long start) {
        this.delegate.setRange(this.serialize(key), this.serialize(value), start);
    }

    @Override
    public Set<String> sInter(String ... keys) {
        Set<byte[]> results = this.delegate.sInter(this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Long sInterStore(String destKey, String ... keys) {
        Long result = this.delegate.sInterStore(this.serialize(destKey), this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean sIsMember(String key, String value) {
        Boolean result = this.delegate.sIsMember(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<String> sMembers(String key) {
        Set<byte[]> results = this.delegate.sMembers(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Boolean sMove(String srcKey, String destKey, String value) {
        Boolean result = this.delegate.sMove(this.serialize(srcKey), this.serialize(destKey), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long sort(String key, SortParameters params, String storeKey) {
        Long result = this.delegate.sort(this.serialize(key), params, this.serialize(storeKey));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public List<String> sort(String key, SortParameters params) {
        List<byte[]> results = this.delegate.sort(this.serialize(key), params);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public String sPop(String key) {
        byte[] result = this.delegate.sPop(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public String sRandMember(String key) {
        byte[] result = this.delegate.sRandMember(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.bytesToString);
        }
        return (String)this.bytesToString.convert((Object)result);
    }

    @Override
    public List<String> sRandMember(String key, long count) {
        List<byte[]> results = this.delegate.sRandMember(this.serialize(key), count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteListToStringList);
        }
        return this.byteListToStringList.convert(results);
    }

    @Override
    public Long sRem(String key, String ... values) {
        Long result = this.delegate.sRem(this.serialize(key), this.serializeMulti(values));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long strLen(String key) {
        Long result = this.delegate.strLen(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long bitCount(String key) {
        Long result = this.delegate.bitCount(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long bitCount(String key, long begin, long end) {
        Long result = this.delegate.bitCount(this.serialize(key), begin, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, String destination, String ... keys) {
        Long result = this.delegate.bitOp(op, this.serialize(destination), this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public void subscribe(MessageListener listener, String ... channels) {
        this.delegate.subscribe(listener, this.serializeMulti(channels));
    }

    @Override
    public Set<String> sUnion(String ... keys) {
        Set<byte[]> results = this.delegate.sUnion(this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Long sUnionStore(String destKey, String ... keys) {
        Long result = this.delegate.sUnionStore(this.serialize(destKey), this.serializeMulti(keys));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long ttl(String key) {
        Long result = this.delegate.ttl(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public DataType type(String key) {
        DataType result = this.delegate.type(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Boolean zAdd(String key, double score, String value) {
        Boolean result = this.delegate.zAdd(this.serialize(key), score, this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zAdd(String key, Set<StringRedisConnection.StringTuple> tuples) {
        Long result = this.delegate.zAdd(this.serialize(key), this.stringTupleToTuple.convert(tuples));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zCard(String key) {
        Long result = this.delegate.zCard(this.serialize(key));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zCount(String key, double min, double max) {
        Long result = this.delegate.zCount(this.serialize(key), min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double zIncrBy(String key, double increment, String value) {
        Double result = this.delegate.zIncrBy(this.serialize(key), increment, this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zInterStore(String destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, String ... sets) {
        Long result = this.delegate.zInterStore(this.serialize(destKey), aggregate, weights, this.serializeMulti(sets));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zInterStore(String destKey, String ... sets) {
        Long result = this.delegate.zInterStore(this.serialize(destKey), this.serializeMulti(sets));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<String> zRange(String key, long start, long end) {
        Set<byte[]> results = this.delegate.zRange(this.serialize(key), start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max, long offset, long count) {
        Set<byte[]> results = this.delegate.zRangeByScore(this.serialize(key), min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max) {
        Set<byte[]> results = this.delegate.zRangeByScore(this.serialize(key), min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRangeByScoreWithScores(this.serialize(key), min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.tupleToStringTuple);
        }
        return this.tupleToStringTuple.convert(results);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeByScoreWithScores(String key, double min, double max) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRangeByScoreWithScores(this.serialize(key), min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.tupleToStringTuple);
        }
        return this.tupleToStringTuple.convert(results);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeWithScores(String key, long start, long end) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRangeWithScores(this.serialize(key), start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.tupleToStringTuple);
        }
        return this.tupleToStringTuple.convert(results);
    }

    @Override
    public Long zRank(String key, String value) {
        Long result = this.delegate.zRank(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zRem(String key, String ... values) {
        Long result = this.delegate.zRem(this.serialize(key), this.serializeMulti(values));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zRemRange(String key, long start, long end) {
        Long result = this.delegate.zRemRange(this.serialize(key), start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zRemRangeByScore(String key, double min, double max) {
        Long result = this.delegate.zRemRangeByScore(this.serialize(key), min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Set<String> zRevRange(String key, long start, long end) {
        Set<byte[]> results = this.delegate.zRevRange(this.serialize(key), start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRevRangeWithScores(String key, long start, long end) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRevRangeWithScores(this.serialize(key), start, end);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.tupleToStringTuple);
        }
        return this.tupleToStringTuple.convert(results);
    }

    @Override
    public Set<String> zRevRangeByScore(String key, double min, double max) {
        Set<byte[]> results = this.delegate.zRevRangeByScore(this.serialize(key), min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRevRangeByScoreWithScores(String key, double min, double max) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRevRangeByScoreWithScores(this.serialize(key), min, max);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.tupleToStringTuple);
        }
        return this.tupleToStringTuple.convert(results);
    }

    @Override
    public Set<String> zRevRangeByScore(String key, double min, double max, long offset, long count) {
        Set<byte[]> results = this.delegate.zRevRangeByScore(this.serialize(key), min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.byteSetToStringSet);
        }
        return this.byteSetToStringSet.convert(results);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRevRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        Set<RedisZSetCommands.Tuple> results = this.delegate.zRevRangeByScoreWithScores(this.serialize(key), min, max, offset, count);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.tupleToStringTuple);
        }
        return this.tupleToStringTuple.convert(results);
    }

    @Override
    public Long zRevRank(String key, String value) {
        Long result = this.delegate.zRevRank(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Double zScore(String key, String value) {
        Double result = this.delegate.zScore(this.serialize(key), this.serialize(value));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zUnionStore(String destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, String ... sets) {
        Long result = this.delegate.zUnionStore(this.serialize(destKey), aggregate, weights, this.serializeMulti(sets));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long zUnionStore(String destKey, String ... sets) {
        Long result = this.delegate.zUnionStore(this.serialize(destKey), this.serializeMulti(sets));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> closePipeline() {
        try {
            List<Object> list = this.convertResults(this.delegate.closePipeline(), this.pipelineConverters);
            return list;
        }
        finally {
            this.pipelineConverters.clear();
        }
    }

    @Override
    public boolean isPipelined() {
        return this.delegate.isPipelined();
    }

    @Override
    public void openPipeline() {
        this.delegate.openPipeline();
    }

    @Override
    public Object execute(String command) {
        return this.execute(command, (byte[][])null);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Object result = this.delegate.execute(command, args);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Object execute(String command, String ... args) {
        return this.execute(command, this.serializeMulti(args));
    }

    @Override
    public Boolean pExpire(String key, long millis) {
        return this.pExpire(this.serialize(key), millis);
    }

    @Override
    public Boolean pExpireAt(String key, long unixTimeInMillis) {
        return this.pExpireAt(this.serialize(key), unixTimeInMillis);
    }

    @Override
    public Long pTtl(String key) {
        return this.pTtl(this.serialize(key));
    }

    @Override
    public String scriptLoad(String script) {
        String result = this.delegate.scriptLoad(this.serialize(script));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public <T> T eval(String script, ReturnType returnType, int numKeys, String ... keysAndArgs) {
        Object result = this.delegate.eval(this.serialize(script), returnType, numKeys, this.serializeMulti(keysAndArgs));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, String ... keysAndArgs) {
        Object result = this.delegate.evalSha(scriptSha1, returnType, numKeys, this.serializeMulti(keysAndArgs));
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return result;
    }

    @Override
    public Long time() {
        return this.delegate.time();
    }

    public void setDeserializePipelineAndTxResults(boolean deserializePipelineAndTxResults) {
        this.deserializePipelineAndTxResults = deserializePipelineAndTxResults;
    }

    private void addResultConverter(Converter<?, ?> converter) {
        if (this.isQueueing()) {
            this.txConverters.add(converter);
        } else {
            this.pipelineConverters.add(converter);
        }
    }

    private boolean isFutureConversion() {
        return this.isPipelined() || this.isQueueing();
    }

    private List<Object> convertResults(List<Object> results, Queue<Converter> converters) {
        if (!this.deserializePipelineAndTxResults || results == null) {
            return results;
        }
        if (results.size() != converters.size()) {
            this.log.warn((Object)"Delegate returned an unexpected number of results. Abandoning type conversion.");
            return results;
        }
        ArrayList<Object> convertedResults = new ArrayList<Object>();
        for (Object result : results) {
            convertedResults.add(converters.remove().convert(result));
        }
        return convertedResults;
    }

    private class TransactionResultConverter
    implements Converter<List<Object>, List<Object>> {
        private Queue<Converter> txConverters;

        public TransactionResultConverter(Queue<Converter> txConverters) {
            this.txConverters = txConverters;
        }

        public List<Object> convert(List<Object> execResults) {
            return DefaultStringRedisConnection.this.convertResults(execResults, this.txConverters);
        }
    }

    private class IdentityConverter
    implements Converter<Object, Object> {
        private IdentityConverter() {
        }

        public Object convert(Object source) {
            return source;
        }
    }

    private class StringTupleConverter
    implements Converter<StringRedisConnection.StringTuple, RedisZSetCommands.Tuple> {
        private StringTupleConverter() {
        }

        public RedisZSetCommands.Tuple convert(StringRedisConnection.StringTuple source) {
            return new DefaultTuple(source.getValue(), source.getScore());
        }
    }

    private class TupleConverter
    implements Converter<RedisZSetCommands.Tuple, StringRedisConnection.StringTuple> {
        private TupleConverter() {
        }

        public StringRedisConnection.StringTuple convert(RedisZSetCommands.Tuple source) {
            return new DefaultStringTuple(source, (String)DefaultStringRedisConnection.this.serializer.deserialize(source.getValue()));
        }
    }

    private class DeserializingConverter
    implements Converter<byte[], String> {
        private DeserializingConverter() {
        }

        public String convert(byte[] source) {
            return (String)DefaultStringRedisConnection.this.serializer.deserialize(source);
        }
    }
}

