/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.cache.DefaultRedisCachePrefix;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCachePrefix;
import org.springframework.data.redis.core.RedisTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private final Collection<String> names = Collections.unmodifiableSet(this.caches.keySet());
    private final RedisTemplate template;
    private boolean usePrefix = false;
    private RedisCachePrefix cachePrefix = new DefaultRedisCachePrefix();
    private long defaultExpiration = 0L;
    private Map<String, Long> expires = null;

    public RedisCacheManager(RedisTemplate template) {
        this.template = template;
    }

    public Cache getCache(String name) {
        Cache c = (Cache)this.caches.get(name);
        if (c == null) {
            long expiration = this.computeExpiration(name);
            c = new RedisCache(name, this.usePrefix ? this.cachePrefix.prefix(name) : null, this.template, expiration);
            this.caches.put(name, c);
        }
        return c;
    }

    private long computeExpiration(String name) {
        Long expiration = null;
        if (this.expires != null) {
            expiration = this.expires.get(name);
        }
        return expiration != null ? expiration : this.defaultExpiration;
    }

    public Collection<String> getCacheNames() {
        return this.names;
    }

    public void setUsePrefix(boolean usePrefix) {
        this.usePrefix = usePrefix;
    }

    public void setCachePrefix(RedisCachePrefix cachePrefix) {
        this.cachePrefix = cachePrefix;
    }

    public void setDefaultExpiration(long defaultExpireTime) {
        this.defaultExpiration = defaultExpireTime;
    }

    public void setExpires(Map<String, Long> expires) {
        this.expires = expires != null ? new ConcurrentHashMap<String, Long>(expires) : null;
    }
}

