/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LettuceConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private final Log log = LogFactory.getLog(this.getClass());
    private String hostName = "localhost";
    private int port = 6379;
    private RedisClient client;
    private long timeout = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private boolean validateConnection = false;
    private boolean shareNativeConnection = true;
    private RedisAsyncConnection<byte[], byte[]> connection;
    private int dbIndex = 0;
    private final Object connectionMonitor = new Object();

    public LettuceConnectionFactory() {
    }

    public LettuceConnectionFactory(String host, int port) {
        this.hostName = host;
        this.port = port;
    }

    public void afterPropertiesSet() {
        this.client = new RedisClient(this.hostName, this.port);
        this.client.setDefaultTimeout(this.timeout, TimeUnit.MILLISECONDS);
        if (this.shareNativeConnection) {
            this.initConnection();
        }
    }

    public void destroy() {
        this.resetConnection();
        this.client.shutdown();
    }

    @Override
    public RedisConnection getConnection() {
        RedisAsyncConnection<byte[], byte[]> nativeConnection = this.getNativeConnection();
        if (this.dbIndex > 0) {
            nativeConnection.select(this.dbIndex);
        }
        return new LettuceConnection(nativeConnection, this.timeout, this.client, !this.shareNativeConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.resetConnection();
            }
            this.connection = this.client.connectAsync(LettuceUtils.CODEC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            try {
                new com.lambdaworks.redis.RedisConnection(this.connection).ping();
            }
            catch (RedisException e) {
                this.log.warn((Object)"Validation of shared connection failed. Creating a new connection.");
                this.initConnection();
            }
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return LettuceUtils.convertRedisAccessException(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean getValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public boolean getShareNativeConnection() {
        return this.shareNativeConnection;
    }

    public void setShareNativeConnection(boolean shareNativeConnection) {
        this.shareNativeConnection = shareNativeConnection;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RedisAsyncConnection<byte[], byte[]> getNativeConnection() {
        if (this.shareNativeConnection) {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.connection == null) {
                    this.initConnection();
                }
                if (this.validateConnection) {
                    this.validateConnection();
                }
                return this.connection;
            }
        }
        return this.client.connectAsync(LettuceUtils.CODEC);
    }
}

