/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.rjc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.idevlab.rjc.ds.DataSource;
import org.idevlab.rjc.ds.PoolableDataSource;
import org.idevlab.rjc.ds.SimpleDataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.rjc.RjcConnection;
import org.springframework.data.redis.connection.rjc.RjcUtils;
import org.springframework.util.Assert;

public class RjcConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private static final Log log = LogFactory.getLog(RjcConnectionFactory.class);
    private String hostName = "localhost";
    private int port = 6379;
    private int timeout = 2000;
    private String password;
    private boolean usePool = true;
    private int dbIndex = 0;
    private DataSource dataSource;

    public void afterPropertiesSet() {
        if (this.usePool) {
            PoolableDataSource pool = new PoolableDataSource();
            pool.setHost(this.hostName);
            pool.setPort(this.port);
            pool.setPassword(this.password);
            pool.setTimeout(this.timeout);
            pool.init();
            this.dataSource = pool;
        } else {
            this.dataSource = new SimpleDataSource(this.hostName, this.port, this.timeout, this.password);
        }
    }

    public void destroy() {
        if (this.usePool && this.dataSource != null) {
            try {
                ((PoolableDataSource)this.dataSource).close();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close Rjc pool", (Throwable)ex);
            }
            this.dataSource = null;
        }
    }

    public RedisConnection getConnection() {
        return this.postProcessConnection(new RjcConnection(this.dataSource.getConnection(), this.dbIndex));
    }

    protected RjcConnection postProcessConnection(RjcConnection connection) {
        return connection;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return RjcUtils.convertRjcAccessException(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean getUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }
}

