/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.support;

import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.r2dbc.BadSqlGrammarException;
import org.springframework.data.r2dbc.support.AbstractFallbackR2dbcExceptionTranslator;
import org.springframework.data.r2dbc.support.SqlStateR2dbcExceptionTranslator;
import org.springframework.lang.Nullable;

@Deprecated
public class R2dbcExceptionSubclassTranslator
extends AbstractFallbackR2dbcExceptionTranslator {
    public R2dbcExceptionSubclassTranslator() {
        this.setFallbackTranslator(new SqlStateR2dbcExceptionTranslator());
    }

    @Override
    @Nullable
    protected DataAccessException doTranslate(String task, @Nullable String sql, R2dbcException ex) {
        if (ex instanceof R2dbcTransientException) {
            if (ex instanceof R2dbcTransientResourceException) {
                return new TransientDataAccessResourceException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcRollbackException) {
                return new ConcurrencyFailureException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcTimeoutException) {
                return new QueryTimeoutException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
        }
        if (ex instanceof R2dbcNonTransientException) {
            if (ex instanceof R2dbcNonTransientResourceException) {
                return new DataAccessResourceFailureException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcDataIntegrityViolationException) {
                return new DataIntegrityViolationException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcPermissionDeniedException) {
                return new PermissionDeniedDataAccessException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcBadGrammarException) {
                return new BadSqlGrammarException(task, sql != null ? sql : "", ex);
            }
        }
        return null;
    }
}

