/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.data.r2dbc.repository.query.ExpressionQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcSpELExpressionEvaluator;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.r2dbc.core.DatabaseClient;

class ExpressionEvaluatingParameterBinder {
    private final ExpressionQuery expressionQuery;
    private final Map<String, Boolean> namedParameters = new ConcurrentHashMap<String, Boolean>();

    ExpressionEvaluatingParameterBinder(ExpressionQuery expressionQuery) {
        this.expressionQuery = expressionQuery;
    }

    DatabaseClient.GenericExecuteSpec bind(DatabaseClient.GenericExecuteSpec bindSpec, RelationalParameterAccessor parameterAccessor, R2dbcSpELExpressionEvaluator evaluator) {
        Object[] values = parameterAccessor.getValues();
        Parameters bindableParameters = parameterAccessor.getBindableParameters();
        DatabaseClient.GenericExecuteSpec bindSpecToUse = this.bindExpressions(bindSpec, evaluator);
        bindSpecToUse = this.bindParameters(bindSpecToUse, parameterAccessor.hasBindableNullValue(), values, bindableParameters);
        return bindSpecToUse;
    }

    private DatabaseClient.GenericExecuteSpec bindExpressions(DatabaseClient.GenericExecuteSpec bindSpec, R2dbcSpELExpressionEvaluator evaluator) {
        DatabaseClient.GenericExecuteSpec bindSpecToUse = bindSpec;
        for (ExpressionQuery.ParameterBinding binding : this.expressionQuery.getBindings()) {
            org.springframework.r2dbc.core.Parameter valueForBinding = evaluator.evaluate(binding.getExpression());
            if (valueForBinding.isEmpty()) {
                bindSpecToUse = bindSpecToUse.bindNull(binding.getParameterName(), valueForBinding.getType());
                continue;
            }
            bindSpecToUse = bindSpecToUse.bind(binding.getParameterName(), valueForBinding.getValue());
        }
        return bindSpecToUse;
    }

    private DatabaseClient.GenericExecuteSpec bindParameters(DatabaseClient.GenericExecuteSpec bindSpec, boolean bindableNull, Object[] values, Parameters<?, ?> bindableParameters) {
        DatabaseClient.GenericExecuteSpec bindSpecToUse = bindSpec;
        int bindingIndex = 0;
        for (Parameter bindableParameter : bindableParameters) {
            Object value = values[bindableParameter.getIndex()];
            Optional name = bindableParameter.getName();
            if (name.isPresent() && this.isNamedParameterUsed(name) || !this.expressionQuery.getBindings().isEmpty()) {
                if (!this.isNamedParameterUsed(name)) continue;
                if (value == null) {
                    if (!bindableNull) continue;
                    bindSpecToUse = bindSpecToUse.bindNull((String)name.get(), bindableParameter.getType());
                    continue;
                }
                bindSpecToUse = bindSpecToUse.bind((String)name.get(), value);
                continue;
            }
            if (value == null) {
                if (!bindableNull) continue;
                bindSpecToUse = bindSpecToUse.bindNull(bindingIndex++, bindableParameter.getType());
                continue;
            }
            bindSpecToUse = bindSpecToUse.bind(bindingIndex++, value);
        }
        return bindSpecToUse;
    }

    private boolean isNamedParameterUsed(Optional<String> name) {
        if (!name.isPresent()) {
            return false;
        }
        return this.namedParameters.computeIfAbsent(name.get(), it -> {
            Pattern namedParameterPattern = Pattern.compile("(\\W)[:#$@]" + Pattern.quote(it) + "(\\W|$)");
            return namedParameterPattern.matcher(this.expressionQuery.getQuery()).find();
        });
    }
}

