/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.connectionfactory.lookup;

import io.r2dbc.spi.ConnectionFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.r2dbc.connectionfactory.lookup.ConnectionFactoryLookup;
import org.springframework.data.r2dbc.connectionfactory.lookup.ConnectionFactoryLookupFailureException;
import org.springframework.util.Assert;

public class MapConnectionFactoryLookup
implements ConnectionFactoryLookup {
    private final Map<String, ConnectionFactory> connectionFactories = new HashMap<String, ConnectionFactory>();

    public MapConnectionFactoryLookup() {
    }

    public MapConnectionFactoryLookup(Map<String, ConnectionFactory> connectionFactories) {
        this.setConnectionFactories(connectionFactories);
    }

    public MapConnectionFactoryLookup(String connectionFactoryName, ConnectionFactory connectionFactory) {
        this.addConnectionFactory(connectionFactoryName, connectionFactory);
    }

    public void setConnectionFactories(Map<String, ConnectionFactory> connectionFactories) {
        Assert.notNull(connectionFactories, (String)"ConnectionFactories must not be null!");
        this.connectionFactories.putAll(connectionFactories);
    }

    public Map<String, ConnectionFactory> getConnectionFactories() {
        return Collections.unmodifiableMap(this.connectionFactories);
    }

    public void addConnectionFactory(String connectionFactoryName, ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactoryName, (String)"ConnectionFactory name must not be null!");
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        this.connectionFactories.put(connectionFactoryName, connectionFactory);
    }

    @Override
    public ConnectionFactory getConnectionFactory(String connectionFactoryName) throws ConnectionFactoryLookupFailureException {
        Assert.notNull((Object)connectionFactoryName, (String)"ConnectionFactory name must not be null!");
        return this.connectionFactories.computeIfAbsent(connectionFactoryName, key -> {
            throw new ConnectionFactoryLookupFailureException("No ConnectionFactory with name '" + connectionFactoryName + "' registered");
        });
    }
}

