/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;

class ExpressionQuery {
    private static final char CURLY_BRACE_OPEN = '{';
    private static final char CURLY_BRACE_CLOSE = '}';
    private static final String SYNTHETIC_PARAMETER_TEMPLATE = "__synthetic_%d__";
    private static final Pattern EXPRESSION_BINDING_PATTERN = Pattern.compile("[:]#\\{(.*)}");
    private final String query;
    private final List<ParameterBinding> parameterBindings;

    private ExpressionQuery(String query, List<ParameterBinding> parameterBindings) {
        this.query = query;
        this.parameterBindings = parameterBindings;
    }

    public static ExpressionQuery create(String query) {
        ArrayList<ParameterBinding> parameterBindings = new ArrayList<ParameterBinding>();
        String rewritten = ExpressionQuery.transformQueryAndCollectExpressionParametersIntoBindings(query, parameterBindings);
        return new ExpressionQuery(rewritten, parameterBindings);
    }

    public String getQuery() {
        return this.query;
    }

    public List<ParameterBinding> getBindings() {
        return this.parameterBindings;
    }

    private static String transformQueryAndCollectExpressionParametersIntoBindings(String input, List<ParameterBinding> bindings) {
        Matcher matcher;
        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        int currentPosition = 0;
        int parameterIndex = 0;
        while (currentPosition < input.length() && (matcher = ExpressionQuery.findNextBindingOrExpression(input, currentPosition)) != null) {
            int exprStart;
            currentPosition = exprStart = matcher.start();
            int curlyBraceOpenCount = 1;
            currentPosition += 3;
            block5: while (curlyBraceOpenCount > 0 && currentPosition < input.length()) {
                switch (input.charAt(currentPosition++)) {
                    case '{': {
                        ++curlyBraceOpenCount;
                        continue block5;
                    }
                    case '}': {
                        --curlyBraceOpenCount;
                        continue block5;
                    }
                }
            }
            result.append(input.subSequence(startIndex, exprStart));
            String parameterName = String.format(SYNTHETIC_PARAMETER_TEMPLATE, parameterIndex++);
            result.append(':').append(parameterName);
            bindings.add(ParameterBinding.named(parameterName, matcher.group(1)));
            startIndex = currentPosition = matcher.end();
        }
        return result.append(input.subSequence(currentPosition, input.length())).toString();
    }

    @Nullable
    private static Matcher findNextBindingOrExpression(String input, int position) {
        Matcher matcher = EXPRESSION_BINDING_PATTERN.matcher(input);
        if (matcher.find(position)) {
            return matcher;
        }
        return null;
    }

    public String toString() {
        return this.query;
    }

    static class ParameterBinding {
        private final String parameterName;
        private final String expression;

        private ParameterBinding(String parameterName, String expression) {
            this.expression = expression;
            this.parameterName = parameterName;
        }

        static ParameterBinding named(String name, String expression) {
            return new ParameterBinding(name, expression);
        }

        String getExpression() {
            return this.expression;
        }

        String getParameterName() {
            return this.parameterName;
        }
    }
}

