/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import org.neo4j.driver.Driver;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionHolder;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;

final class Neo4jSessionSynchronization
extends ResourceHolderSynchronization<Neo4jTransactionHolder, Object> {
    private final Neo4jTransactionHolder localConnectionHolder;

    Neo4jSessionSynchronization(Neo4jTransactionHolder connectionHolder, Driver driver) {
        super((ResourceHolder)connectionHolder, (Object)driver);
        this.localConnectionHolder = connectionHolder;
    }

    protected boolean shouldReleaseBeforeCompletion() {
        return false;
    }

    protected void processResourceAfterCommit(Neo4jTransactionHolder resourceHolder) {
        super.processResourceAfterCommit((ResourceHolder)resourceHolder);
        if (resourceHolder.hasActiveTransaction()) {
            resourceHolder.commit();
        }
    }

    public void afterCompletion(int status) {
        if (status == 1 && this.localConnectionHolder.hasActiveTransaction()) {
            this.localConnectionHolder.rollback();
        }
        super.afterCompletion(status);
    }

    protected void releaseResource(Neo4jTransactionHolder resourceHolder, Object resourceKey) {
        if (resourceHolder.hasActiveSession()) {
            resourceHolder.close();
        }
    }
}

