/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.schema.Relationship;

@API(status=API.Status.INTERNAL, since="6.0")
public interface RelationshipDescription {
    public static final String NAME_OF_RELATIONSHIP = "__relationship__";
    public static final String NAME_OF_RELATIONSHIP_TYPE = "__relationshipType__";

    public String getType();

    public boolean isDynamic();

    public NodeDescription<?> getSource();

    public NodeDescription<?> getTarget();

    public String getFieldName();

    public Relationship.Direction getDirection();

    public @Nullable NodeDescription<?> getRelationshipPropertiesEntity();

    default public NodeDescription<?> getRequiredRelationshipPropertiesEntity() {
        return Objects.requireNonNull(this.getRelationshipPropertiesEntity(), () -> "Relationship entity %s does not point to an entity holding the relationships' properties".formatted(this.getType()));
    }

    public boolean hasRelationshipProperties();

    default public boolean hasInternalIdProperty() {
        return this.hasRelationshipProperties() && Optional.ofNullable(this.getRelationshipPropertiesEntity()).map(NodeDescription::getIdDescription).filter(IdDescription::isInternallyGeneratedId).isPresent();
    }

    default public boolean isOutgoing() {
        return Relationship.Direction.OUTGOING.equals((Object)this.getDirection());
    }

    default public boolean isIncoming() {
        return Relationship.Direction.INCOMING.equals((Object)this.getDirection());
    }

    default public String generateRelatedNodesCollectionName(NodeDescription<?> mostAbstractNodeDescription) {
        return this.getSource().getMostAbstractParentLabel(mostAbstractNodeDescription) + "_" + this.getType() + "_" + this.getTarget().getPrimaryLabel() + "_" + this.isOutgoing();
    }

    public @Nullable RelationshipDescription getRelationshipObverse();

    public void setRelationshipObverse(@Nullable RelationshipDescription var1);

    public boolean hasRelationshipObverse();

    public boolean cascadeUpdates();
}

