/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.summary.GqlNotification;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ResultSummary;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.core.Neo4jClient;

final class ResultSummaries {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final LogAccessor cypherPerformanceNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.performance"));
    private static final LogAccessor cypherHintNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.hint"));
    private static final LogAccessor cypherUnrecognizedNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.unrecognized"));
    private static final LogAccessor cypherUnsupportedNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.unsupported"));
    private static final LogAccessor cypherDeprecationNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.deprecation"));
    private static final LogAccessor cypherGenericNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.generic"));
    private static final LogAccessor cypherSecurityNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.security"));
    private static final LogAccessor cypherTopologyNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.topology"));
    private static final LogAccessor cypherSchemaNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.schema"));
    private static final List<Pattern> STUFF_THAT_MIGHT_INFORM_THAT_THE_ID_FUNCTION_IS_PROBLEMATIC = Stream.of("(?im)The query used a deprecated function[.:] \\(?[`']id.+", "(?im).*id is deprecated and will be removed without a replacement\\.", "(?im).*feature deprecated with replacement\\. id is deprecated\\. It is replaced by elementId or consider using an application-generated id\\.").map(Pattern::compile).toList();

    private ResultSummaries() {
    }

    static ResultSummary process(ResultSummary resultSummary) {
        ResultSummaries.logNotifications(resultSummary);
        ResultSummaries.logPlan(resultSummary);
        return resultSummary;
    }

    private static void logNotifications(ResultSummary resultSummary) {
        Predicate<GqlNotification> isDeprecationWarningForId;
        if (resultSummary.gqlStatusObjects().isEmpty() || !Neo4jClient.cypherLog.isWarnEnabled()) {
            return;
        }
        boolean supressIdDeprecations = Neo4jClient.SUPPRESS_ID_DEPRECATIONS.getAcquire();
        try {
            isDeprecationWarningForId = notification -> supressIdDeprecations && notification.classification().filter(cat -> cat == NotificationClassification.UNRECOGNIZED || cat == NotificationClassification.DEPRECATION).isPresent() && STUFF_THAT_MIGHT_INFORM_THAT_THE_ID_FUNCTION_IS_PROBLEMATIC.stream().anyMatch(p -> p.matcher(notification.statusDescription()).matches());
        }
        finally {
            Neo4jClient.SUPPRESS_ID_DEPRECATIONS.setRelease(supressIdDeprecations);
        }
        String query = resultSummary.query().text();
        resultSummary.gqlStatusObjects().stream().filter(GqlNotification.class::isInstance).map(GqlNotification.class::cast).filter(Predicate.not(isDeprecationWarningForId)).forEach(notification -> notification.severity().ifPresent(severityLevel -> {
            NotificationClassification category = notification.classification().orElse(null);
            LogAccessor logger = ResultSummaries.getLogAccessor(category);
            Consumer<String> logFunction = severityLevel == NotificationSeverity.WARNING ? arg_0 -> ((LogAccessor)logger).warn(arg_0) : (severityLevel == NotificationSeverity.INFORMATION ? arg_0 -> ((LogAccessor)logger).info(arg_0) : (severityLevel == NotificationSeverity.OFF ? message -> {} : arg_0 -> ((LogAccessor)logger).debug(arg_0)));
            logFunction.accept(ResultSummaries.format(notification, query));
        }));
    }

    private static LogAccessor getLogAccessor(@Nullable NotificationClassification classification) {
        if (classification == null) {
            return Neo4jClient.cypherLog;
        }
        return switch (classification) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationClassification.HINT -> cypherHintNotificationLog;
            case NotificationClassification.UNRECOGNIZED -> cypherUnrecognizedNotificationLog;
            case NotificationClassification.UNSUPPORTED -> cypherUnsupportedNotificationLog;
            case NotificationClassification.PERFORMANCE -> cypherPerformanceNotificationLog;
            case NotificationClassification.DEPRECATION -> cypherDeprecationNotificationLog;
            case NotificationClassification.SECURITY -> cypherSecurityNotificationLog;
            case NotificationClassification.TOPOLOGY -> cypherTopologyNotificationLog;
            case NotificationClassification.GENERIC -> cypherGenericNotificationLog;
            case NotificationClassification.SCHEMA -> cypherSchemaNotificationLog;
        };
    }

    static String format(GqlNotification notification, String forQuery) {
        InputPosition position = notification.position().orElse(null);
        StringBuilder queryHint = new StringBuilder();
        String[] lines = forQuery.split("(\r\n|\n)");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            queryHint.append("\t").append(line).append(LINE_SEPARATOR);
            if (position == null || i2 + 1 != position.line()) continue;
            queryHint.append("\t").append(Stream.generate(() -> " ").limit(position.column() - 1).collect(Collectors.joining())).append("^").append(System.lineSeparator());
        }
        return String.format("%s (%s):%n%s", notification.statusDescription(), notification.gqlStatus(), queryHint);
    }

    private static void logPlan(ResultSummary resultSummary) {
        if (!resultSummary.hasPlan() || !Neo4jClient.cypherLog.isDebugEnabled()) {
            return;
        }
        Consumer<String> log = arg_0 -> ((LogAccessor)Neo4jClient.cypherLog).debug(arg_0);
        log.accept("Plan:");
        ResultSummaries.printPlan(log, resultSummary.plan(), 0);
    }

    private static void printPlan(Consumer<String> log, Plan plan, int level) {
        String tabs = Stream.generate(() -> "\t").limit(level).collect(Collectors.joining());
        log.accept(tabs + "operatorType: " + plan.operatorType());
        log.accept(tabs + "identifiers: " + String.join((CharSequence)",", plan.identifiers()));
        log.accept(tabs + "arguments: ");
        plan.arguments().forEach((k, v) -> log.accept(tabs + "\t" + k + "=" + String.valueOf(v)));
        if (!plan.children().isEmpty()) {
            log.accept(tabs + "children: ");
            for (Plan childPlan : plan.children()) {
                ResultSummaries.printPlan(log, childPlan, level + 1);
            }
        }
    }
}

