/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.neo4j.config.EnableNeo4jAuditing;
import org.springframework.data.neo4j.core.mapping.callback.AuditingBeforeBindCallback;
import org.springframework.util.Assert;

final class Neo4jAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static final String AUDITING_HANDLER_BEAN_NAME = "neo4jAuditingHandler";

    Neo4jAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableNeo4jAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return AUDITING_HANDLER_BEAN_NAME;
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuditingBeforeBindCallback.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), AuditingBeforeBindCallback.class.getName(), registry);
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class);
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    public void postProcess(BeanDefinitionBuilder builder, AuditingConfiguration configuration, BeanDefinitionRegistry registry) {
        builder.setFactoryMethod("from").addConstructorArgReference("neo4jMappingContext");
    }
}

