/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL)
public final class IdentitySupport {
    private IdentitySupport() {
    }

    public static String getElementId(Entity entity) {
        return entity.elementId();
    }

    @Nullable
    public static String getElementId(@NonNull MapAccessor row) {
        if (row instanceof Entity) {
            Entity entity = (Entity)row;
            return IdentitySupport.getElementId(entity);
        }
        String columnToUse = "__elementId__";
        Value value = row.get(columnToUse);
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.hasType(TypeSystem.getDefault().NUMBER())) {
            return value.asNumber().toString();
        }
        return value.asString();
    }

    @Nullable
    @Deprecated
    public static Long getInternalId(@NonNull MapAccessor row) {
        if (row instanceof Entity) {
            Entity entity = (Entity)row;
            return entity.id();
        }
        String columnToUse = "__internalNeo4jId__";
        if (row.get(columnToUse) == null || row.get(columnToUse).isNull()) {
            return null;
        }
        return row.get(columnToUse).asLong();
    }

    @Nullable
    public static String getPrefixedElementId(@NonNull MapAccessor queryResult, @Nullable String seed) {
        if (queryResult instanceof Node) {
            return "N" + IdentitySupport.getElementId(queryResult);
        }
        if (queryResult instanceof Relationship) {
            return "R" + seed + IdentitySupport.getElementId(queryResult);
        }
        if (queryResult.get("__elementId__") != null && !queryResult.get("__elementId__").isNull()) {
            Value value = queryResult.get("__elementId__");
            if (value.hasType(TypeSystem.getDefault().NUMBER())) {
                return "N" + String.valueOf(value.asNumber());
            }
            return "N" + value.asString();
        }
        return null;
    }

    public static Function<MapAccessor, Object> mapperForRelatedIdValues(@Nullable Neo4jPersistentProperty idProperty) {
        boolean deprecatedHolder = idProperty != null && Neo4jPersistentEntity.DEPRECATED_GENERATED_ID_TYPES.contains(idProperty.getType());
        return deprecatedHolder ? IdentitySupport::getInternalId : IdentitySupport::getElementId;
    }
}

