/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ResultSummary;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.core.Neo4jClient;

final class ResultSummaries {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final LogAccessor cypherPerformanceNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.performance"));
    private static final LogAccessor cypherHintNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.hint"));
    private static final LogAccessor cypherUnrecognizedNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.unrecognized"));
    private static final LogAccessor cypherUnsupportedNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.unsupported"));
    private static final LogAccessor cypherDeprecationNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.deprecation"));
    private static final LogAccessor cypherGenericNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.generic"));
    private static final LogAccessor cypherSecurityNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.security"));
    private static final LogAccessor cypherTopologyNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.topology"));

    static ResultSummary process(ResultSummary resultSummary) {
        ResultSummaries.logNotifications(resultSummary);
        ResultSummaries.logPlan(resultSummary);
        return resultSummary;
    }

    private static void logNotifications(ResultSummary resultSummary) {
        if (resultSummary.notifications().isEmpty() || !Neo4jClient.cypherLog.isWarnEnabled()) {
            return;
        }
        String query = resultSummary.query().text();
        resultSummary.notifications().forEach(notification -> {
            LogAccessor log = notification.category().map(ResultSummaries::getLogAccessor).orElse(Neo4jClient.cypherLog);
            Consumer<String> logFunction = switch (notification.severity()) {
                case "WARNING" -> arg_0 -> ((LogAccessor)log).warn(arg_0);
                case "INFORMATION" -> arg_0 -> ((LogAccessor)log).info(arg_0);
                default -> arg_0 -> ((LogAccessor)log).debug(arg_0);
            };
            logFunction.accept(ResultSummaries.format(notification, query));
        });
    }

    private static LogAccessor getLogAccessor(NotificationCategory category) {
        if (category == NotificationCategory.HINT) {
            return cypherHintNotificationLog;
        }
        if (category == NotificationCategory.DEPRECATION) {
            return cypherDeprecationNotificationLog;
        }
        if (category == NotificationCategory.PERFORMANCE) {
            return cypherPerformanceNotificationLog;
        }
        if (category == NotificationCategory.GENERIC) {
            return cypherGenericNotificationLog;
        }
        if (category == NotificationCategory.UNSUPPORTED) {
            return cypherUnsupportedNotificationLog;
        }
        if (category == NotificationCategory.UNRECOGNIZED) {
            return cypherUnrecognizedNotificationLog;
        }
        if (category == NotificationCategory.SECURITY) {
            return cypherSecurityNotificationLog;
        }
        if (category == NotificationCategory.TOPOLOGY) {
            return cypherTopologyNotificationLog;
        }
        return Neo4jClient.cypherLog;
    }

    static String format(Notification notification, String forQuery) {
        InputPosition position = notification.position();
        boolean hasPosition = position != null;
        StringBuilder queryHint = new StringBuilder();
        String[] lines = forQuery.split("(\r\n|\n)");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            queryHint.append("\t").append(line).append(LINE_SEPARATOR);
            if (!hasPosition || i2 + 1 != position.line()) continue;
            queryHint.append("\t").append(Stream.generate(() -> " ").limit(position.column() - 1).collect(Collectors.joining())).append("^").append(System.lineSeparator());
        }
        return String.format("%s: %s%n%s%s", notification.code(), notification.title(), queryHint, notification.description());
    }

    private static void logPlan(ResultSummary resultSummary) {
        if (!resultSummary.hasPlan() || !Neo4jClient.cypherLog.isDebugEnabled()) {
            return;
        }
        Consumer<String> log = arg_0 -> ((LogAccessor)Neo4jClient.cypherLog).debug(arg_0);
        log.accept("Plan:");
        ResultSummaries.printPlan(log, resultSummary.plan(), 0);
    }

    private static void printPlan(Consumer<String> log, Plan plan, int level) {
        String tabs = Stream.generate(() -> "\t").limit(level).collect(Collectors.joining());
        log.accept(tabs + "operatorType: " + plan.operatorType());
        log.accept(tabs + "identifiers: " + String.join((CharSequence)",", plan.identifiers()));
        log.accept(tabs + "arguments: ");
        plan.arguments().forEach((k, v) -> log.accept(tabs + "\t" + k + "=" + String.valueOf(v)));
        if (!plan.children().isEmpty()) {
            log.accept(tabs + "children: ");
            for (Plan childPlan : plan.children()) {
                ResultSummaries.printPlan(log, childPlan, level + 1);
            }
        }
    }

    private ResultSummaries() {
    }
}

