/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.CypherdslBasedQuery;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.PartTreeNeo4jQuery;
import org.springframework.data.neo4j.repository.query.StringBasedNeo4jQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;

@API(status=API.Status.INTERNAL, since="6.0")
public final class Neo4jQueryLookupStrategy
implements QueryLookupStrategy {
    private final Neo4jMappingContext mappingContext;
    private final Neo4jOperations neo4jOperations;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final Configuration configuration;

    public Neo4jQueryLookupStrategy(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, QueryMethodEvaluationContextProvider evaluationContextProvider, Configuration configuration) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
        this.evaluationContextProvider = evaluationContextProvider;
        this.configuration = configuration;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        Neo4jQueryMethod queryMethod = new Neo4jQueryMethod(method, metadata, factory);
        String namedQueryName = queryMethod.getNamedQueryName();
        if (namedQueries.hasQuery(namedQueryName)) {
            return StringBasedNeo4jQuery.create(this.neo4jOperations, this.mappingContext, this.evaluationContextProvider, queryMethod, namedQueries.getQuery(namedQueryName), factory);
        }
        if (queryMethod.hasQueryAnnotation()) {
            return StringBasedNeo4jQuery.create(this.neo4jOperations, this.mappingContext, this.evaluationContextProvider, queryMethod, factory);
        }
        if (queryMethod.isCypherBasedProjection()) {
            return CypherdslBasedQuery.create(this.neo4jOperations, this.mappingContext, queryMethod, factory, arg_0 -> ((Renderer)Renderer.getRenderer((Configuration)this.configuration)).render(arg_0));
        }
        return PartTreeNeo4jQuery.create(this.neo4jOperations, this.mappingContext, queryMethod, factory);
    }
}

