/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Predicates;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.driver.types.Point;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.repository.query.BoundingBox;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQuerySupport;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.PartValidator;
import org.springframework.data.neo4j.repository.query.PropertyPathWrapper;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

final class CypherQueryCreator
extends AbstractQueryCreator<QueryFragmentsAndParameters, Condition> {
    private final Neo4jMappingContext mappingContext;
    private final QueryMethod queryMethod;
    private final Class<?> domainType;
    private final NodeDescription<?> nodeDescription;
    private final Neo4jQueryType queryType;
    private final boolean isDistinct;
    private final Iterator<Neo4jQueryMethod.Neo4jParameter> formalParameters;
    private final Queue<Parameter> lastParameter = new LinkedList<Parameter>();
    private final Supplier<String> indexSupplier = new IndexSupplier();
    private final BiFunction<Object, Neo4jPersistentPropertyConverter<?>, Object> parameterConversion;
    private final List<Parameter> boundedParameters = new ArrayList<Parameter>();
    private final Pageable pagingParameter;
    private final ScrollPosition scrollPosition;
    private final Number maxResults;
    private final List<SortItem> sortItems = new ArrayList<SortItem>();
    private final Collection<PropertyFilter.ProjectedPath> includedProperties;
    private final List<PropertyPathWrapper> propertyPathWrappers;
    private final boolean keysetRequiresSort;
    private final UnaryOperator<Integer> limitModifier;

    CypherQueryCreator(Neo4jMappingContext mappingContext, QueryMethod queryMethod, Class<?> domainType, Neo4jQueryType queryType, PartTree tree, Neo4jParameterAccessor actualParameters, Collection<PropertyFilter.ProjectedPath> includedProperties, BiFunction<Object, Neo4jPersistentPropertyConverter<?>, Object> parameterConversion, UnaryOperator<Integer> limitModifier) {
        super(tree, (ParameterAccessor)actualParameters);
        this.mappingContext = mappingContext;
        this.queryMethod = queryMethod;
        this.domainType = domainType;
        this.nodeDescription = this.mappingContext.getRequiredNodeDescription(this.domainType);
        this.queryType = queryType;
        this.isDistinct = tree.isDistinct();
        this.formalParameters = actualParameters.getParameters().iterator();
        this.maxResults = tree.isLimiting() ? tree.getMaxResults() : null;
        this.includedProperties = includedProperties;
        this.parameterConversion = parameterConversion;
        this.pagingParameter = actualParameters.getPageable();
        this.scrollPosition = actualParameters.getScrollPosition();
        this.limitModifier = limitModifier;
        AtomicInteger symbolicNameIndex = new AtomicInteger();
        this.propertyPathWrappers = tree.getParts().stream().map(part -> new PropertyPathWrapper(symbolicNameIndex.getAndIncrement(), mappingContext.getPersistentPropertyPath(part.getProperty()))).collect(Collectors.toList());
        this.keysetRequiresSort = queryMethod.isScrollQuery() && actualParameters.getScrollPosition() instanceof KeysetScrollPosition;
    }

    protected Condition create(Part part, Iterator<Object> actualParameters) {
        return this.createImpl(part, actualParameters);
    }

    protected Condition and(Part part, Condition base, Iterator<Object> actualParameters) {
        if (base == null) {
            return this.create(part, actualParameters);
        }
        return base.and(this.createImpl(part, actualParameters));
    }

    protected Condition or(Condition base, Condition condition) {
        return base.or(condition);
    }

    protected QueryFragmentsAndParameters complete(@Nullable Condition condition, Sort sort) {
        Map<String, Object> convertedParameters = this.boundedParameters.stream().peek(p -> Neo4jQuerySupport.logParameterIfNull(p.nameOrIndex, p.value)).collect(Collectors.toMap(p -> p.nameOrIndex, p -> this.parameterConversion.apply(p.value, p.conversionOverride)));
        QueryFragments queryFragments = this.createQueryFragments(condition, sort);
        Sort theSort = this.pagingParameter.getSort().and(sort);
        if (this.keysetRequiresSort && theSort.isUnsorted()) {
            throw new UnsupportedOperationException("Unsorted keyset based scrolling is not supported.");
        }
        return new QueryFragmentsAndParameters(this.nodeDescription, queryFragments, convertedParameters, theSort);
    }

    @NonNull
    private QueryFragments createQueryFragments(@Nullable Condition condition, Sort sort) {
        QueryFragments queryFragments = new QueryFragments();
        Node startNode = Cypher.node((String)this.nodeDescription.getPrimaryLabel(), this.nodeDescription.getAdditionalLabels()).named(Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription));
        Condition conditionFragment = Optional.ofNullable(condition).orElseGet(Conditions::noCondition);
        ArrayList<PatternElement> relationshipChain = new ArrayList<PatternElement>();
        for (PropertyPathWrapper possiblePathWithRelationship : this.propertyPathWrappers) {
            if (!possiblePathWithRelationship.hasRelationships()) continue;
            relationshipChain.add((PatternElement)((RelationshipPattern)possiblePathWithRelationship.createRelationshipChain((ExposesRelationships<?>)startNode)));
        }
        if (!relationshipChain.isEmpty()) {
            queryFragments.setMatchOn(relationshipChain);
        } else {
            queryFragments.addMatchOn((PatternElement)startNode);
        }
        if (this.queryType == Neo4jQueryType.COUNT) {
            queryFragments.setReturnExpression((Expression)Functions.count((Expression)Cypher.asterisk()), true);
        } else if (this.queryType == Neo4jQueryType.EXISTS) {
            queryFragments.setReturnExpression((Expression)Functions.count((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription))).gt((Expression)Cypher.literalOf((Object)0)), true);
        } else if (this.queryType == Neo4jQueryType.DELETE) {
            queryFragments.setDeleteExpression((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription));
            queryFragments.setReturnExpression((Expression)Functions.count((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription))), true);
        } else {
            Sort theSort = this.pagingParameter.getSort().and(sort);
            if (this.pagingParameter.isUnpaged() && this.scrollPosition == null && this.maxResults != null) {
                queryFragments.setLimit((Number)this.limitModifier.apply(this.maxResults.intValue()));
            } else {
                ScrollPosition scrollPosition = this.scrollPosition;
                if (scrollPosition instanceof KeysetScrollPosition) {
                    KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
                    Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.nodeDescription;
                    theSort = theSort.and(Sort.by((String[])new String[]{((Neo4jPersistentProperty)entity.getRequiredIdProperty()).getName()}).ascending());
                    queryFragments.setLimit((Number)this.limitModifier.apply(this.maxResults.intValue()));
                    if (!keysetScrollPosition.isInitial()) {
                        conditionFragment = conditionFragment.and(CypherAdapterUtils.combineKeysetIntoCondition(entity, keysetScrollPosition, theSort, this.mappingContext.getConversionService()));
                    }
                    queryFragments.setRequiresReverseSort(keysetScrollPosition.scrollsBackward());
                } else {
                    scrollPosition = this.scrollPosition;
                    if (scrollPosition instanceof OffsetScrollPosition) {
                        OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)scrollPosition;
                        queryFragments.setSkip(offsetScrollPosition.getOffset());
                        queryFragments.setLimit((Number)this.limitModifier.apply(this.pagingParameter.isUnpaged() ? this.maxResults.intValue() : this.pagingParameter.getPageSize()));
                    }
                }
            }
            queryFragments.setReturnBasedOn(this.nodeDescription, this.includedProperties, this.isDistinct);
            queryFragments.setOrderBy(Stream.concat(this.sortItems.stream(), theSort.stream().map(CypherAdapterUtils.sortAdapterFor(this.nodeDescription))).collect(Collectors.toList()));
        }
        queryFragments.setCondition(conditionFragment);
        return queryFragments;
    }

    private Condition createImpl(Part part, Iterator<Object> actualParameters) {
        PersistentPropertyPath path = this.mappingContext.getPersistentPropertyPath(part.getProperty());
        Neo4jPersistentProperty property = (Neo4jPersistentProperty)path.getLeafProperty();
        boolean ignoreCase = this.ignoreCase(part);
        if (property.isComposite()) {
            Condition compositePropertyCondition = CypherGenerator.INSTANCE.createCompositePropertyCondition(property, Cypher.name((String)this.getContainerName((PersistentPropertyPath<Neo4jPersistentProperty>)path, (Neo4jPersistentEntity)property.getOwner())), this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            if (part.getType() == Part.Type.NEGATING_SIMPLE_PROPERTY) {
                compositePropertyCondition = Conditions.not((Condition)compositePropertyCondition);
            }
            return compositePropertyCondition;
        }
        return switch (part.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Part.Type.AFTER, Part.Type.GREATER_THAN -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).gt(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.BEFORE, Part.Type.LESS_THAN -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).lt(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.BETWEEN -> this.betweenCondition((PersistentPropertyPath<Neo4jPersistentProperty>)path, actualParameters, ignoreCase);
            case Part.Type.CONTAINING -> this.containingCondition((PersistentPropertyPath<Neo4jPersistentProperty>)path, property, actualParameters, ignoreCase);
            case Part.Type.ENDING_WITH -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).endsWith(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.EXISTS -> Predicates.exists((Property)this.toCypherProperty(property));
            case Part.Type.FALSE -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isFalse();
            case Part.Type.GREATER_THAN_EQUAL -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).gte(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.IN -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).in(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.IS_EMPTY -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isEmpty();
            case Part.Type.IS_NOT_EMPTY -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isEmpty().not();
            case Part.Type.IS_NOT_NULL -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isNotNull();
            case Part.Type.IS_NULL -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isNull();
            case Part.Type.LESS_THAN_EQUAL -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).lte(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.LIKE -> this.likeCondition((PersistentPropertyPath<Neo4jPersistentProperty>)path, this.nextRequiredParameter(actualParameters, (Neo4jPersistentProperty)property).nameOrIndex, ignoreCase);
            case Part.Type.NEAR -> this.createNearCondition((PersistentPropertyPath<Neo4jPersistentProperty>)path, actualParameters);
            case Part.Type.NEGATING_SIMPLE_PROPERTY -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isNotEqualTo(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.NOT_CONTAINING -> this.containingCondition((PersistentPropertyPath<Neo4jPersistentProperty>)path, property, actualParameters, ignoreCase).not();
            case Part.Type.NOT_IN -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).in(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase)).not();
            case Part.Type.NOT_LIKE -> this.likeCondition((PersistentPropertyPath<Neo4jPersistentProperty>)path, this.nextRequiredParameter(actualParameters, (Neo4jPersistentProperty)property).nameOrIndex, ignoreCase).not();
            case Part.Type.SIMPLE_PROPERTY -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isEqualTo(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.STARTING_WITH -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).startsWith(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.REGEX -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).matches(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
            case Part.Type.TRUE -> this.toCypherProperty((PersistentPropertyPath<Neo4jPersistentProperty>)path, ignoreCase).isTrue();
            case Part.Type.WITHIN -> this.createWithinCondition((PersistentPropertyPath<Neo4jPersistentProperty>)path, actualParameters);
        };
    }

    private Condition containingCondition(PersistentPropertyPath<Neo4jPersistentProperty> path, Neo4jPersistentProperty property, Iterator<Object> actualParameters, boolean ignoreCase) {
        Expression cypherProperty = this.toCypherProperty(path, ignoreCase);
        if (property.isDynamicLabels()) {
            Neo4jPersistentProperty leafProperty = (Neo4jPersistentProperty)path.getLeafProperty();
            Neo4jPersistentEntity owner = (Neo4jPersistentEntity)leafProperty.getOwner();
            String containerName = this.getContainerName(path, owner);
            return this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase).in((Expression)Functions.labels((Node)Cypher.anyNode((String)containerName)));
        }
        if (property.isCollectionLike()) {
            return this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase).in(cypherProperty);
        }
        return cypherProperty.contains(this.toCypherParameter(this.nextRequiredParameter(actualParameters, property), ignoreCase));
    }

    boolean ignoreCase(Part part) {
        return switch (part.shouldIgnoreCase()) {
            default -> throw new IncompatibleClassChangeError();
            case Part.IgnoreCaseType.ALWAYS -> true;
            case Part.IgnoreCaseType.WHEN_POSSIBLE -> PartValidator.canIgnoreCase(part);
            case Part.IgnoreCaseType.NEVER -> false;
        };
    }

    private Condition likeCondition(PersistentPropertyPath<Neo4jPersistentProperty> path, String parameterName, boolean ignoreCase) {
        String regexOptions = ignoreCase ? "(?i)" : "";
        return this.toCypherProperty(path, false).matches((Expression)Cypher.literalOf((Object)(regexOptions + ".*")).concat((Expression)Cypher.parameter((String)parameterName)).concat((Expression)Cypher.literalOf((Object)".*")));
    }

    private Condition betweenCondition(PersistentPropertyPath<Neo4jPersistentProperty> path, Iterator<Object> actualParameters, boolean ignoreCase) {
        Neo4jPersistentProperty leafProperty = (Neo4jPersistentProperty)path.getLeafProperty();
        Parameter lowerBoundOrRange = this.nextRequiredParameter(actualParameters, leafProperty);
        Expression property = this.toCypherProperty(path, ignoreCase);
        if (lowerBoundOrRange.value instanceof Range) {
            return this.createRangeConditionForProperty(property, lowerBoundOrRange);
        }
        Parameter upperBound = this.nextRequiredParameter(actualParameters, leafProperty);
        return property.gte(this.toCypherParameter(lowerBoundOrRange, ignoreCase)).and(property.lte(this.toCypherParameter(upperBound, ignoreCase)));
    }

    private Condition createNearCondition(PersistentPropertyPath<Neo4jPersistentProperty> path, Iterator<Object> actualParameters) {
        Optional<Parameter> other;
        Expression referencePoint;
        Neo4jPersistentProperty leafProperty = (Neo4jPersistentProperty)path.getLeafProperty();
        Parameter p1 = this.nextRequiredParameter(actualParameters, leafProperty);
        Optional<Parameter> p2 = this.nextOptionalParameter(actualParameters, leafProperty);
        if (p1.value instanceof Point) {
            referencePoint = this.toCypherParameter(p1, false);
            other = p2;
        } else if (p2.isPresent() && p2.get().value instanceof Point) {
            referencePoint = this.toCypherParameter(p2.get(), false);
            other = Optional.of(p1);
        } else {
            throw new IllegalArgumentException(String.format("The NEAR operation requires a reference point of type %s", Point.class));
        }
        FunctionInvocation distanceFunction = Functions.distance((Expression)this.toCypherProperty(path, false), (Expression)referencePoint);
        if (other.filter(p -> p.hasValueOfType(Distance.class)).isPresent()) {
            return distanceFunction.lte(this.toCypherParameter(other.get(), false));
        }
        if (other.filter(p -> p.hasValueOfType(Range.class)).isPresent()) {
            return this.createRangeConditionForProperty((Expression)distanceFunction, other.get());
        }
        other.ifPresent(this.lastParameter::offer);
        this.sortItems.add(distanceFunction.ascending());
        return Conditions.noCondition();
    }

    private Condition createWithinCondition(PersistentPropertyPath<Neo4jPersistentProperty> path, Iterator<Object> actualParameters) {
        Neo4jPersistentProperty leafProperty = (Neo4jPersistentProperty)path.getLeafProperty();
        Parameter area = this.nextRequiredParameter(actualParameters, leafProperty);
        if (area.hasValueOfType(Circle.class)) {
            FunctionInvocation referencePoint = Functions.point((MapExpression)Cypher.mapOf((Object[])new Object[]{"x", this.createCypherParameter(area.nameOrIndex + ".x", false), "y", this.createCypherParameter(area.nameOrIndex + ".y", false), "srid", Cypher.property((Expression)this.toCypherProperty(path, false), (String[])new String[]{"srid"})}));
            FunctionInvocation distanceFunction = Functions.distance((Expression)this.toCypherProperty(path, false), (Expression)referencePoint);
            return distanceFunction.lte(this.createCypherParameter(area.nameOrIndex + ".radius", false));
        }
        if (area.hasValueOfType(BoundingBox.class) || area.hasValueOfType(Box.class)) {
            Expression llx = this.createCypherParameter(area.nameOrIndex + ".llx", false);
            Expression lly = this.createCypherParameter(area.nameOrIndex + ".lly", false);
            Expression urx = this.createCypherParameter(area.nameOrIndex + ".urx", false);
            Expression ury = this.createCypherParameter(area.nameOrIndex + ".ury", false);
            Property x = Cypher.property((Expression)this.toCypherProperty(path, false), (String[])new String[]{"x"});
            Property y = Cypher.property((Expression)this.toCypherProperty(path, false), (String[])new String[]{"y"});
            return llx.lte((Expression)x).and(x.lte(urx)).and(lly.lte((Expression)y)).and(y.lte(ury));
        }
        if (area.hasValueOfType(Polygon.class)) {
            throw new IllegalArgumentException(String.format("The WITHIN operation does not support a %s, you might want to pass a bounding box instead: %s.of(polygon)", Polygon.class, BoundingBox.class));
        }
        throw new IllegalArgumentException(String.format("The WITHIN operation requires an area of type %s or %s", Circle.class, Box.class));
    }

    private Condition createRangeConditionForProperty(Expression property, Parameter rangeParameter) {
        Expression parameterPlaceholder;
        Range range = (Range)rangeParameter.value;
        Condition betweenCondition = Conditions.noCondition();
        if (range.getLowerBound().isBounded()) {
            parameterPlaceholder = this.createCypherParameter(rangeParameter.nameOrIndex + ".lb", false);
            betweenCondition = betweenCondition.and(range.getLowerBound().isInclusive() ? property.gte(parameterPlaceholder) : property.gt(parameterPlaceholder));
        }
        if (range.getUpperBound().isBounded()) {
            parameterPlaceholder = this.createCypherParameter(rangeParameter.nameOrIndex + ".ub", false);
            betweenCondition = betweenCondition.and(range.getUpperBound().isInclusive() ? property.lte(parameterPlaceholder) : property.lt(parameterPlaceholder));
        }
        return betweenCondition;
    }

    private Property toCypherProperty(Neo4jPersistentProperty persistentProperty) {
        return Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription)), (String[])new String[]{persistentProperty.getPropertyName()});
    }

    private Expression toCypherProperty(PersistentPropertyPath<Neo4jPersistentProperty> path, boolean addToLower) {
        Neo4jPersistentProperty leafProperty = (Neo4jPersistentProperty)path.getLeafProperty();
        Neo4jPersistentEntity owner = (Neo4jPersistentEntity)leafProperty.getOwner();
        String containerName = this.getContainerName(path, owner);
        Object expression = owner.equals(this.nodeDescription) && path.getLength() == 1 ? (leafProperty.isInternalIdProperty() && owner.isUsingDeprecatedInternalId() ? ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)"id").withArgs(new Expression[]{(Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription)})).asFunction() : (leafProperty.isInternalIdProperty() ? ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)"elementId").withArgs(new Expression[]{(Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription)})).asFunction() : Cypher.property((String)containerName, (String[])new String[]{leafProperty.getPropertyName()}))) : (leafProperty.isInternalIdProperty() && owner.isUsingDeprecatedInternalId() ? ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)"id").withArgs(new Expression[]{Cypher.name((String)containerName)})).asFunction() : (leafProperty.isInternalIdProperty() ? ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)"elementId").withArgs(new Expression[]{Cypher.name((String)containerName)})).asFunction() : Cypher.property((String)containerName, (String[])new String[]{leafProperty.getPropertyName()})));
        if (addToLower) {
            expression = Functions.toLower((Expression)expression);
        }
        return expression;
    }

    private String getContainerName(PersistentPropertyPath<Neo4jPersistentProperty> path, Neo4jPersistentEntity<?> owner) {
        if (owner.equals(this.nodeDescription) && path.getLength() == 1) {
            return Constants.NAME_OF_TYPED_ROOT_NODE.apply(this.nodeDescription).getValue();
        }
        PropertyPathWrapper propertyPathWrapper = this.propertyPathWrappers.stream().filter(rp -> rp.getPersistentPropertyPath().equals((Object)path)).findFirst().get();
        String cypherElementName = owner.isRelationshipPropertiesEntity() ? propertyPathWrapper.getRelationshipName() : propertyPathWrapper.getNodeName();
        return cypherElementName;
    }

    private Expression toCypherParameter(Parameter parameter, boolean addToLower) {
        return this.createCypherParameter(parameter.nameOrIndex, addToLower);
    }

    private Expression createCypherParameter(String name, boolean addToLower) {
        org.neo4j.cypherdsl.core.Parameter expression = Cypher.parameter((String)name);
        if (addToLower) {
            expression = Functions.toLower((Expression)expression);
        }
        return expression;
    }

    private Optional<Parameter> nextOptionalParameter(Iterator<Object> actualParameters, Neo4jPersistentProperty property) {
        Parameter nextRequiredParameter = this.lastParameter.poll();
        if (nextRequiredParameter != null) {
            return Optional.of(nextRequiredParameter);
        }
        if (this.formalParameters.hasNext()) {
            Neo4jQueryMethod.Neo4jParameter parameter = this.formalParameters.next();
            Parameter boundedParameter = new Parameter(parameter.getName().orElseGet(this.indexSupplier), actualParameters.next(), property.getOptionalConverter());
            this.boundedParameters.add(boundedParameter);
            return Optional.of(boundedParameter);
        }
        return Optional.empty();
    }

    private Parameter nextRequiredParameter(Iterator<Object> actualParameters, Neo4jPersistentProperty property) {
        Parameter nextRequiredParameter = this.lastParameter.poll();
        if (nextRequiredParameter != null) {
            return nextRequiredParameter;
        }
        if (!this.formalParameters.hasNext()) {
            throw new IllegalStateException("Not enough formal, bindable parameters for parts");
        }
        Neo4jQueryMethod.Neo4jParameter parameter = this.formalParameters.next();
        Parameter boundedParameter = new Parameter(parameter.getName().orElseGet(this.indexSupplier), actualParameters.next(), property.getOptionalConverter());
        this.boundedParameters.add(boundedParameter);
        return boundedParameter;
    }

    static final class IndexSupplier
    implements Supplier<String> {
        private AtomicInteger current = new AtomicInteger(0);

        IndexSupplier() {
        }

        @Override
        public String get() {
            return Integer.toString(this.current.getAndIncrement());
        }
    }

    static class Parameter {
        final String nameOrIndex;
        final Object value;
        @Nullable
        final Neo4jPersistentPropertyConverter<?> conversionOverride;

        Parameter(String nameOrIndex, Object value, @Nullable Neo4jPersistentPropertyConverter<?> conversionOverride) {
            this.nameOrIndex = nameOrIndex;
            this.value = value;
            this.conversionOverride = conversionOverride;
        }

        boolean hasValueOfType(Class<?> type) {
            return type.isInstance(this.value);
        }

        public String toString() {
            return "Parameter{nameOrIndex='" + this.nameOrIndex + "', value=" + this.value + "}";
        }
    }
}

