/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.apiguardian.api.API;
import org.neo4j.driver.Driver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.Neo4jConfigurationSupport;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ReactiveNeo4jTemplate;
import org.springframework.data.neo4j.core.ReactiveUserSelectionProvider;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarkManager;
import org.springframework.data.neo4j.core.transaction.ReactiveNeo4jTransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.transaction.ReactiveTransactionManager;

@Configuration
@API(status=API.Status.STABLE, since="6.0")
public abstract class AbstractReactiveNeo4jConfig
extends Neo4jConfigurationSupport {
    @Autowired
    private ObjectProvider<ReactiveUserSelectionProvider> userSelectionProviders;
    @Autowired
    private Neo4jBookmarkManager bookmarkManager;

    public abstract Driver driver();

    @Bean(value={"reactiveNeo4jClient"})
    public ReactiveNeo4jClient neo4jClient(Driver driver, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        return ReactiveNeo4jClient.with(driver).withDatabaseSelectionProvider(databaseSelectionProvider).withUserSelectionProvider(this.getUserSelectionProvider()).withNeo4jBookmarkManager(this.bookmarkManager).build();
    }

    @Nullable
    private ReactiveUserSelectionProvider getUserSelectionProvider() {
        return this.userSelectionProviders == null ? null : (ReactiveUserSelectionProvider)this.userSelectionProviders.getIfUnique();
    }

    @Bean(value={"reactiveNeo4jTemplate"})
    public ReactiveNeo4jTemplate neo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext mappingContext) {
        return new ReactiveNeo4jTemplate(neo4jClient, mappingContext);
    }

    @Bean(value={"reactiveTransactionManager"})
    public ReactiveTransactionManager reactiveTransactionManager(Driver driver, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        return ReactiveNeo4jTransactionManager.with(driver).withDatabaseSelectionProvider(databaseSelectionProvider).withUserSelectionProvider(this.getUserSelectionProvider()).withBookmarkManager(this.bookmarkManager).build();
    }

    @Bean
    public Neo4jBookmarkManager bookmarkManager() {
        return Neo4jBookmarkManager.createReactive();
    }

    @Bean
    protected ReactiveDatabaseSelectionProvider reactiveDatabaseSelectionProvider() {
        return ReactiveDatabaseSelectionProvider.getDefaultSelectionProvider();
    }
}

