/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.ReactiveFluentFindOperation;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.neo4j.repository.query.QuerydslNeo4jPredicateExecutor;
import org.springframework.data.neo4j.repository.query.ReactiveFluentQueryByPredicate;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.repository.query.FluentQuery;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.2")
public final class ReactiveQuerydslNeo4jPredicateExecutor<T>
implements ReactiveQuerydslPredicateExecutor<T> {
    private final Neo4jEntityInformation<T, Object> entityInformation;
    private final ReactiveNeo4jOperations neo4jOperations;
    private final Neo4jPersistentEntity<T> metaData;

    public ReactiveQuerydslNeo4jPredicateExecutor(Neo4jEntityInformation<T, Object> entityInformation, ReactiveNeo4jOperations neo4jOperations) {
        this.entityInformation = entityInformation;
        this.neo4jOperations = neo4jOperations;
        this.metaData = this.entityInformation.getEntityMetaData();
    }

    public Mono<T> findOne(Predicate predicate) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, Cypher.adapt((Object)predicate).asCondition(), null, null)).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    public Flux<T> findAll(Predicate predicate) {
        return this.doFindAll(Cypher.adapt((Object)predicate).asCondition(), null);
    }

    public Flux<T> findAll(Predicate predicate, Sort sort) {
        return this.doFindAll(Cypher.adapt((Object)predicate).asCondition(), CypherAdapterUtils.toSortItems(this.metaData, sort));
    }

    public Flux<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.doFindAll(Cypher.adapt((Object)predicate).asCondition(), Arrays.asList(QuerydslNeo4jPredicateExecutor.toSortItems(orders)));
    }

    public Flux<T> findAll(OrderSpecifier<?> ... orders) {
        return this.doFindAll(Conditions.noCondition(), Arrays.asList(QuerydslNeo4jPredicateExecutor.toSortItems(orders)));
    }

    private Flux<T> doFindAll(Condition condition, Collection<SortItem> sortItems) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition, null, sortItems)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    public Mono<Long> count(Predicate predicate) {
        Statement statement = CypherGenerator.INSTANCE.prepareMatchOf(this.metaData, Cypher.adapt((Object)predicate).asCondition()).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.neo4jOperations.count(statement, (Map<String, Object>)statement.getParameters());
    }

    public Mono<Boolean> exists(Predicate predicate) {
        return this.findAll(predicate).hasElements();
    }

    public <S extends T, R, P extends Publisher<R>> P findBy(Predicate predicate, Function<FluentQuery.ReactiveFluentQuery<S>, P> queryFunction) {
        ReactiveNeo4jOperations reactiveNeo4jOperations = this.neo4jOperations;
        if (reactiveNeo4jOperations instanceof ReactiveFluentFindOperation) {
            ReactiveFluentFindOperation ops = (ReactiveFluentFindOperation)((Object)reactiveNeo4jOperations);
            ReactiveFluentQueryByPredicate fluentQuery = new ReactiveFluentQueryByPredicate(predicate, this.metaData, this.metaData.getType(), ops, this::count, this::exists);
            return (P)((Publisher)queryFunction.apply(fluentQuery));
        }
        throw new UnsupportedOperationException("Fluent find by example not supported with standard Neo4jOperations, must support fluent queries too");
    }
}

