/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import org.apiguardian.api.API;
import org.neo4j.driver.Record;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL)
public final class IdentitySupport {
    private IdentitySupport() {
    }

    public static void updateInternalId(Neo4jPersistentEntity<?> entityMetaData, PersistentPropertyAccessor<?> propertyAccessor, Entity entity) {
        if (!entityMetaData.isUsingInternalIds()) {
            return;
        }
        propertyAccessor.setProperty(entityMetaData.getRequiredIdProperty(), (Object)IdentitySupport.getInternalId(entity));
    }

    public static Long getInternalId(Entity entity) {
        return entity.id();
    }

    @Nullable
    public static Long getInternalId(@NonNull MapAccessor row) {
        if (row instanceof Entity) {
            Entity entity = (Entity)row;
            return IdentitySupport.getInternalId(entity);
        }
        String columnToUse = "__internalNeo4jId__";
        if (row.get(columnToUse) == null || row.get(columnToUse).isNull()) {
            return null;
        }
        return row.get(columnToUse).asLong();
    }

    @Nullable
    public static String getInternalId(@NonNull MapAccessor queryResult, @Nullable String seed) {
        if (queryResult instanceof Node) {
            return "N" + IdentitySupport.getInternalId(queryResult);
        }
        if (queryResult instanceof Relationship) {
            return "R" + seed + IdentitySupport.getInternalId(queryResult);
        }
        if (queryResult.get("__internalNeo4jId__") != null && !queryResult.get("__internalNeo4jId__").isNull()) {
            return "N" + queryResult.get("__internalNeo4jId__").asLong();
        }
        return null;
    }

    public static Long getStartId(Relationship relationship) {
        return relationship.startNodeId();
    }

    public static Long getEndId(Relationship relationship) {
        return relationship.endNodeId();
    }

    public static Long getInternalId(TypeSystem typeSystem, Record row) {
        return IdentitySupport.getInternalId((MapAccessor)row);
    }
}

