/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.types;

import org.apiguardian.api.API;
import org.springframework.data.neo4j.types.AbstractPoint;
import org.springframework.data.neo4j.types.Coordinate;

@API(status=API.Status.STABLE, since="6.0")
public final class GeographicPoint3d
extends AbstractPoint {
    GeographicPoint3d(Coordinate coordinate, Integer srid) {
        super(coordinate, srid);
    }

    public GeographicPoint3d(double latitude, double longitude, double height) {
        super(new Coordinate(longitude, latitude, height), 4979);
    }

    public double getLongitude() {
        return this.coordinate.getX();
    }

    public double getLatitude() {
        return this.coordinate.getY();
    }

    public double getHeight() {
        return this.coordinate.getZ();
    }

    public String toString() {
        return "GeographicPoint3d{longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", height=" + this.getHeight() + ", srid=" + this.getSrid() + '}';
    }
}

