/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.function.Function;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.repository.query.parser.PartTree;

enum Neo4jQueryType {
    DEFAULT,
    COUNT,
    EXISTS,
    DELETE;


    static Neo4jQueryType fromPartTree(PartTree partTree) {
        return Neo4jQueryType.getOrThrow(partTree.isCountProjection(), partTree.isExistsProjection(), partTree.isDelete());
    }

    static Neo4jQueryType fromDefinition(Query definition) {
        return Neo4jQueryType.getOrThrow(definition.count(), definition.exists(), definition.delete());
    }

    private static Neo4jQueryType getOrThrow(boolean countQuery, boolean existsQuery, boolean deleteQuery) {
        Neo4jQueryType queryType = DEFAULT;
        Function<Neo4jQueryType, IllegalArgumentException> exceptionSupplier = qt -> new IllegalArgumentException("Query type already defined as " + (Object)qt);
        if (countQuery) {
            queryType = COUNT;
        }
        if (existsQuery) {
            if (queryType != DEFAULT) {
                throw exceptionSupplier.apply(queryType);
            }
            queryType = EXISTS;
        }
        if (deleteQuery) {
            if (queryType != DEFAULT) {
                throw exceptionSupplier.apply(queryType);
            }
            queryType = DELETE;
        }
        return queryType;
    }
}

