/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.driver.Driver;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Record;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.DefaultNeo4jClient;
import org.springframework.data.neo4j.core.UserSelection;
import org.springframework.data.neo4j.core.UserSelectionProvider;
import org.springframework.lang.Nullable;

@API(status=API.Status.STABLE, since="6.0")
public interface Neo4jClient {
    public static final LogAccessor cypherLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher"));
    public static final LogAccessor log = new LogAccessor(LogFactory.getLog(Neo4jClient.class));

    public static Neo4jClient create(Driver driver) {
        return Neo4jClient.with(driver).build();
    }

    public static Neo4jClient create(Driver driver, DatabaseSelectionProvider databaseSelectionProvider) {
        return Neo4jClient.with(driver).withDatabaseSelectionProvider(databaseSelectionProvider).build();
    }

    public static Builder with(Driver driver) {
        return new Builder(driver);
    }

    default public QueryRunner getQueryRunner() {
        return this.getQueryRunner(DatabaseSelection.undecided());
    }

    default public QueryRunner getQueryRunner(DatabaseSelection databaseSelection) {
        return this.getQueryRunner(databaseSelection, UserSelection.connectedUser());
    }

    public QueryRunner getQueryRunner(DatabaseSelection var1, UserSelection var2);

    public UnboundRunnableSpec query(String var1);

    public UnboundRunnableSpec query(Supplier<String> var1);

    public <T> OngoingDelegation<T> delegateTo(Function<QueryRunner, Optional<T>> var1);

    @Nullable
    public DatabaseSelectionProvider getDatabaseSelectionProvider();

    @Nullable
    public static String verifyDatabaseName(@Nullable String databaseName) {
        String newTargetDatabase;
        String string = newTargetDatabase = databaseName == null ? null : databaseName.trim();
        if (newTargetDatabase != null && newTargetDatabase.isEmpty()) {
            throw new IllegalDatabaseNameException(newTargetDatabase);
        }
        return newTargetDatabase;
    }

    @API(status=API.Status.STABLE, since="6.1.5")
    public static class IllegalDatabaseNameException
    extends IllegalArgumentException {
        private final String illegalDatabaseName;

        private IllegalDatabaseNameException(String illegalDatabaseName) {
            super("Either use null to indicate the default database or a valid database name. The empty string is not permitted.");
            this.illegalDatabaseName = illegalDatabaseName;
        }

        public String getIllegalDatabaseName() {
            return this.illegalDatabaseName;
        }
    }

    public static interface RunnableDelegation<T> {
        public Optional<T> run();
    }

    public static interface OngoingDelegation<T>
    extends RunnableDelegation<T> {
        public RunnableDelegation<T> in(@Nullable String var1);
    }

    public static interface RecordFetchSpec<T> {
        public Optional<T> one();

        public Optional<T> first();

        public Collection<T> all();
    }

    public static interface MappingSpec<T>
    extends RecordFetchSpec<T> {
        public RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> var1);
    }

    public static interface OngoingBindSpec<T, S extends BindSpec<S>> {
        public S to(String var1);

        public S with(Function<T, Map<String, Object>> var1);
    }

    public static interface BindSpec<S extends BindSpec<S>> {
        public <T> OngoingBindSpec<T, S> bind(@Nullable T var1);

        public S bindAll(Map<String, Object> var1);
    }

    public static interface RunnableSpecBoundToDatabaseAndUser
    extends RunnableSpec {
    }

    public static interface RunnableSpecBoundToUser
    extends RunnableSpec {
        public RunnableSpecBoundToDatabaseAndUser in(String var1);
    }

    public static interface RunnableSpecBoundToDatabase
    extends RunnableSpec {
        public RunnableSpecBoundToDatabaseAndUser asUser(String var1);
    }

    public static interface UnboundRunnableSpec
    extends RunnableSpec {
        public RunnableSpecBoundToDatabase in(@Nullable String var1);

        public RunnableSpecBoundToUser asUser(@Nullable String var1);
    }

    public static interface RunnableSpec
    extends BindSpec<RunnableSpec> {
        public <T> MappingSpec<T> fetchAs(Class<T> var1);

        public RecordFetchSpec<Map<String, Object>> fetch();

        public ResultSummary run();
    }

    @API(status=API.Status.STABLE, since="6.2")
    public static class Builder {
        final Driver driver;
        @Nullable
        DatabaseSelectionProvider databaseSelectionProvider;
        @Nullable
        UserSelectionProvider userSelectionProvider;

        private Builder(Driver driver) {
            this.driver = driver;
        }

        public Builder withDatabaseSelectionProvider(@Nullable DatabaseSelectionProvider databaseSelectionProvider) {
            this.databaseSelectionProvider = databaseSelectionProvider;
            return this;
        }

        public Builder withUserSelectionProvider(@Nullable UserSelectionProvider userSelectionProvider) {
            this.userSelectionProvider = userSelectionProvider;
            return this;
        }

        public Neo4jClient build() {
            return new DefaultNeo4jClient(this);
        }
    }
}

