/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.PropertyFilterSupport;
import org.springframework.data.neo4j.core.mapping.DtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryExecution;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQuerySupport;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.OptionalUnwrappingConverter;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractNeo4jQuery
extends Neo4jQuerySupport
implements RepositoryQuery {
    protected final Neo4jOperations neo4jOperations;
    private final ProjectionFactory factory;

    AbstractNeo4jQuery(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, Neo4jQueryType queryType, ProjectionFactory factory) {
        super(mappingContext, queryMethod, queryType);
        this.factory = factory;
        Assert.notNull((Object)neo4jOperations, (String)"The Neo4j operations are required.");
        this.neo4jOperations = neo4jOperations;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public final Object execute(Object[] parameters) {
        boolean incrementLimit = this.queryMethod.isSliceQuery() && !this.queryMethod.getQueryAnnotation().map(q -> q.countQuery()).filter(StringUtils::hasText).isPresent();
        Neo4jParameterAccessor parameterAccessor = new Neo4jParameterAccessor((Neo4jQueryMethod.Neo4jParameters)this.queryMethod.getParameters(), parameters);
        ResultProcessor resultProcessor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        ReturnedType returnedType = resultProcessor.getReturnedType();
        PreparedQuery preparedQuery = this.prepareQuery(returnedType.getReturnedType(), PropertyFilterSupport.getInputProperties(resultProcessor, this.factory, this.mappingContext), parameterAccessor, null, this.getMappingFunction(resultProcessor), incrementLimit ? l -> l + 1 : UnaryOperator.identity());
        Page<?> rawResult = new Neo4jQueryExecution.DefaultQueryExecution(this.neo4jOperations).execute(preparedQuery, this.queryMethod.isCollectionLikeQuery() || this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery());
        OptionalUnwrappingConverter preparingConverter = OptionalUnwrappingConverter.INSTANCE;
        if (returnedType.isProjecting()) {
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext);
            preparingConverter = source -> converter.convert((EntityInstanceWithSource)OptionalUnwrappingConverter.INSTANCE.convert(source));
        }
        if (this.queryMethod.isPageQuery()) {
            rawResult = this.createPage(parameterAccessor, (List)rawResult);
        } else if (this.queryMethod.isSliceQuery()) {
            rawResult = this.createSlice(incrementLimit, parameterAccessor, (List)rawResult);
        }
        return resultProcessor.processResult(rawResult, (Converter)preparingConverter);
    }

    private Page<?> createPage(Neo4jParameterAccessor parameterAccessor, List<?> rawResult) {
        LongSupplier totalSupplier = () -> {
            Supplier<PreparedQuery> defaultCountQuery = () -> this.prepareQuery(Long.class, Collections.emptyMap(), parameterAccessor, Neo4jQueryType.COUNT, null, UnaryOperator.identity());
            PreparedQuery countQuery = this.getCountQuery(parameterAccessor).orElseGet(defaultCountQuery);
            return (Long)this.neo4jOperations.toExecutableQuery(countQuery).getRequiredSingleResult();
        };
        return PageableExecutionUtils.getPage(rawResult, (Pageable)parameterAccessor.getPageable(), (LongSupplier)totalSupplier);
    }

    private Slice<?> createSlice(boolean incrementLimit, Neo4jParameterAccessor parameterAccessor, List<?> rawResult) {
        Pageable pageable = parameterAccessor.getPageable();
        if (incrementLimit) {
            return new SliceImpl(rawResult.subList(0, Math.min(rawResult.size(), pageable.getPageSize())), (Pageable)PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSort()), rawResult.size() > pageable.getPageSize());
        }
        PreparedQuery countQuery = this.getCountQuery(parameterAccessor).orElseGet(() -> this.prepareQuery(Long.class, Collections.emptyMap(), parameterAccessor, Neo4jQueryType.COUNT, null, UnaryOperator.identity()));
        long total = (Long)this.neo4jOperations.toExecutableQuery(countQuery).getRequiredSingleResult();
        return new SliceImpl(rawResult, pageable, pageable.getOffset() + (long)pageable.getPageSize() < total);
    }

    protected abstract <T> PreparedQuery<T> prepareQuery(Class<T> var1, Map<PropertyPath, Boolean> var2, Neo4jParameterAccessor var3, @Nullable Neo4jQueryType var4, @Nullable BiFunction<TypeSystem, MapAccessor, ?> var5, @Nullable UnaryOperator<Integer> var6);

    protected Optional<PreparedQuery<Long>> getCountQuery(Neo4jParameterAccessor parameterAccessor) {
        return Optional.empty();
    }
}

