/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping.callback;

import org.apiguardian.api.API;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.mapping.callback.EntityCallback;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.callback.BeforeBindCallback;
import org.springframework.data.neo4j.core.mapping.callback.IdGeneratingBeforeBindCallback;

@API(status=API.Status.INTERNAL, since="6.0.2")
public final class EventSupport {
    private final EntityCallbacks entityCallbacks;

    public static EventSupport discoverCallbacks(Neo4jMappingContext context, BeanFactory beanFactory) {
        EntityCallbacks entityCallbacks = EntityCallbacks.create((BeanFactory)beanFactory);
        EventSupport.addDefaultEntityCallbacks(context, entityCallbacks);
        return new EventSupport(entityCallbacks);
    }

    public static EventSupport useExistingCallbacks(Neo4jMappingContext context, EntityCallbacks entityCallbacks) {
        EventSupport.addDefaultEntityCallbacks(context, entityCallbacks);
        return new EventSupport(entityCallbacks);
    }

    private static void addDefaultEntityCallbacks(Neo4jMappingContext context, EntityCallbacks entityCallbacks) {
        entityCallbacks.addEntityCallback((EntityCallback)new IdGeneratingBeforeBindCallback(context));
    }

    private EventSupport(EntityCallbacks entityCallbacks) {
        this.entityCallbacks = entityCallbacks;
    }

    public <T> T maybeCallBeforeBind(T object) {
        if (object == null) {
            return object;
        }
        return (T)this.entityCallbacks.callback(BeforeBindCallback.class, object, new Object[0]);
    }
}

