/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;
import org.springframework.data.neo4j.core.support.UserAgent;
import org.springframework.lang.Nullable;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;

public final class Neo4jTransactionUtils {
    public static SessionConfig defaultSessionConfig(@Nullable String databaseName) {
        return Neo4jTransactionUtils.sessionConfig(false, Collections.emptyList(), databaseName);
    }

    public static SessionConfig sessionConfig(boolean readOnly, Collection<Bookmark> bookmarks, @Nullable String databaseName) {
        SessionConfig.Builder builder = SessionConfig.builder().withDefaultAccessMode(readOnly ? AccessMode.READ : AccessMode.WRITE).withBookmarks(bookmarks);
        if (databaseName != null) {
            builder.withDatabase(databaseName);
        }
        return builder.build();
    }

    static TransactionConfig createTransactionConfigFrom(TransactionDefinition definition, int defaultTxManagerTimeout) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Neo4jTransactionManager is not allowed to support custom isolation levels.");
        }
        int propagationBehavior = definition.getPropagationBehavior();
        if (propagationBehavior != 0 && propagationBehavior != 3) {
            throw new IllegalTransactionStateException("Neo4jTransactionManager only supports 'required' or 'requires new' propagation.");
        }
        TransactionConfig.Builder builder = TransactionConfig.builder();
        if (definition.getTimeout() > 0) {
            builder = builder.withTimeout(Duration.ofSeconds(definition.getTimeout()));
        } else if (defaultTxManagerTimeout > 0) {
            builder = builder.withTimeout(Duration.ofSeconds(defaultTxManagerTimeout));
        }
        return builder.withMetadata(Collections.singletonMap("app", UserAgent.INSTANCE.toString())).build();
    }

    static boolean namesMapToTheSameDatabase(@Nullable String name1, @Nullable String name2) {
        return Objects.equals(name1, name2);
    }

    static String formatOngoingTxInAnotherDbErrorMessage(String currentDb, String requestedDb) {
        String defaultDatabase = "the default database";
        String _currentDb = currentDb == null ? defaultDatabase : String.format("'%s'", currentDb);
        String _requestedDb = requestedDb == null ? defaultDatabase : String.format("'%s'", requestedDb);
        return String.format("There is already an ongoing Spring transaction for %s, but you request %s", _currentDb, _requestedDb);
    }

    private Neo4jTransactionUtils() {
    }
}

