/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import org.apiguardian.api.API;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarkManager;
import org.springframework.data.neo4j.core.transaction.Neo4jSessionSynchronization;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionContext;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionHolder;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jTransactionManager
extends AbstractPlatformTransactionManager
implements ApplicationContextAware {
    private final Driver driver;
    private final DatabaseSelectionProvider databaseSelectionProvider;
    private final Neo4jBookmarkManager bookmarkManager;

    public Neo4jTransactionManager(Driver driver) {
        this(driver, DatabaseSelectionProvider.getDefaultSelectionProvider());
    }

    public Neo4jTransactionManager(Driver driver, DatabaseSelectionProvider databaseSelectionProvider) {
        this(driver, databaseSelectionProvider, Neo4jBookmarkManager.create());
    }

    public Neo4jTransactionManager(Driver driver, DatabaseSelectionProvider databaseSelectionProvider, Neo4jBookmarkManager bookmarkManager) {
        this.driver = driver;
        this.databaseSelectionProvider = databaseSelectionProvider;
        this.bookmarkManager = bookmarkManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.bookmarkManager.setApplicationEventPublisher((ApplicationEventPublisher)applicationContext);
    }

    @Nullable
    public static Transaction retrieveTransaction(Driver driver, @Nullable String targetDatabase) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        Neo4jTransactionHolder connectionHolder = (Neo4jTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)driver));
        if (connectionHolder != null) {
            Transaction optionalOngoingTransaction = connectionHolder.getTransaction(targetDatabase);
            if (optionalOngoingTransaction != null) {
                return optionalOngoingTransaction;
            }
            throw new IllegalStateException(Neo4jTransactionUtils.formatOngoingTxInAnotherDbErrorMessage(connectionHolder.getDatabaseName(), targetDatabase));
        }
        Session session = driver.session(Neo4jTransactionUtils.defaultSessionConfig(targetDatabase));
        Transaction transaction = session.beginTransaction(TransactionConfig.empty());
        connectionHolder = new Neo4jTransactionHolder(new Neo4jTransactionContext(targetDatabase), session, transaction);
        connectionHolder.setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new Neo4jSessionSynchronization(connectionHolder, driver));
        TransactionSynchronizationManager.bindResource((Object)driver, (Object)((Object)connectionHolder));
        return connectionHolder.getTransaction(targetDatabase);
    }

    private static Neo4jTransactionObject extractNeo4jTransaction(Object transaction) {
        Assert.isInstanceOf(Neo4jTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", Neo4jTransactionObject.class, transaction.getClass()));
        return (Neo4jTransactionObject)transaction;
    }

    private static Neo4jTransactionObject extractNeo4jTransaction(DefaultTransactionStatus status) {
        return Neo4jTransactionManager.extractNeo4jTransaction(status.getTransaction());
    }

    protected Object doGetTransaction() throws TransactionException {
        Neo4jTransactionHolder resourceHolder = (Neo4jTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.driver));
        return new Neo4jTransactionObject(resourceHolder);
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return Neo4jTransactionManager.extractNeo4jTransaction(transaction).hasResourceHolder();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        Neo4jTransactionObject transactionObject = Neo4jTransactionManager.extractNeo4jTransaction(transaction);
        TransactionConfig transactionConfig = Neo4jTransactionUtils.createTransactionConfigFrom(definition, super.getDefaultTimeout());
        boolean readOnly = definition.isReadOnly();
        TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)readOnly);
        try {
            Neo4jTransactionContext context = new Neo4jTransactionContext(this.databaseSelectionProvider.getDatabaseSelection().getValue(), this.bookmarkManager.getBookmarks());
            Session session = this.driver.session(Neo4jTransactionUtils.sessionConfig(readOnly, context.getBookmarks(), context.getDatabaseName()));
            Transaction nativeTransaction = session.beginTransaction(transactionConfig);
            Neo4jTransactionHolder transactionHolder = new Neo4jTransactionHolder(context, session, nativeTransaction);
            transactionHolder.setSynchronizedWithTransaction(true);
            transactionObject.setResourceHolder(transactionHolder);
            TransactionSynchronizationManager.bindResource((Object)this.driver, (Object)((Object)transactionHolder));
        }
        catch (Exception ex) {
            throw new TransactionSystemException(String.format("Could not open a new Neo4j session: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        Neo4jTransactionObject transactionObject = Neo4jTransactionManager.extractNeo4jTransaction(transaction);
        transactionObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.driver);
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        Neo4jTransactionObject transactionObject = Neo4jTransactionManager.extractNeo4jTransaction(transaction);
        transactionObject.setResourceHolder((Neo4jTransactionHolder)((Object)suspendedResources));
        TransactionSynchronizationManager.bindResource((Object)this.driver, (Object)suspendedResources);
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        Neo4jTransactionObject transactionObject = Neo4jTransactionManager.extractNeo4jTransaction(status);
        Neo4jTransactionHolder transactionHolder = transactionObject.getRequiredResourceHolder();
        Bookmark lastBookmark = transactionHolder.commit();
        this.bookmarkManager.updateBookmarks(transactionHolder.getBookmarks(), lastBookmark);
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        Neo4jTransactionObject transactionObject = Neo4jTransactionManager.extractNeo4jTransaction(status);
        transactionObject.getRequiredResourceHolder().rollback();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        Neo4jTransactionObject transactionObject = Neo4jTransactionManager.extractNeo4jTransaction(status);
        transactionObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Neo4jTransactionObject transactionObject = Neo4jTransactionManager.extractNeo4jTransaction(transaction);
        transactionObject.getRequiredResourceHolder().close();
        transactionObject.setResourceHolder(null);
        TransactionSynchronizationManager.unbindResource((Object)this.driver);
    }

    static class Neo4jTransactionObject
    implements SmartTransactionObject {
        private static final String RESOURCE_HOLDER_NOT_PRESENT_MESSAGE = "Neo4jConnectionHolder is required but not present. o_O";
        @Nullable
        private Neo4jTransactionHolder resourceHolder;

        Neo4jTransactionObject(@Nullable Neo4jTransactionHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        void setResourceHolder(@Nullable Neo4jTransactionHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        boolean hasResourceHolder() {
            return this.resourceHolder != null;
        }

        Neo4jTransactionHolder getRequiredResourceHolder() {
            Assert.state((boolean)this.hasResourceHolder(), (String)RESOURCE_HOLDER_NOT_PRESENT_MESSAGE);
            return this.resourceHolder;
        }

        void setRollbackOnly() {
            this.getRequiredResourceHolder().setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.hasResourceHolder() && this.resourceHolder.isRollbackOnly();
        }

        public void flush() {
            TransactionSynchronizationUtils.triggerFlush();
        }
    }
}

