/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.util.Assert;

final class FluentFindOperationSupport
implements FluentFindOperation {
    private final Neo4jTemplate template;

    FluentFindOperationSupport(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public <T> FluentFindOperation.ExecutableFind<T> find(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableFindSupport<T>(this.template, domainType, domainType, null, Collections.emptyMap());
    }

    private static class ExecutableFindSupport<T>
    implements FluentFindOperation.ExecutableFind<T>,
    FluentFindOperation.FindWithProjection<T>,
    FluentFindOperation.FindWithQuery<T>,
    FluentFindOperation.TerminatingFind<T> {
        private final Neo4jTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String query;
        private final Map<String, Object> parameters;

        ExecutableFindSupport(Neo4jTemplate template, Class<?> domainType, Class<T> returnType, String query, Map<String, Object> parameters) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.parameters = parameters;
        }

        @Override
        public <T1> FluentFindOperation.FindWithQuery<T1> as(Class<T1> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null!");
            return new ExecutableFindSupport<T1>(this.template, this.domainType, returnType, this.query, this.parameters);
        }

        @Override
        public FluentFindOperation.TerminatingFind<T> matching(String query, Map<String, Object> parameters) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ExecutableFindSupport<T>(this.template, this.domainType, this.returnType, query, parameters);
        }

        @Override
        public T oneValue() {
            List<T> result = this.doFind(TemplateSupport.FetchType.ONE);
            if (result.isEmpty()) {
                return null;
            }
            return result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.doFind(TemplateSupport.FetchType.ALL);
        }

        private List<T> doFind(TemplateSupport.FetchType fetchType) {
            return this.template.doFind(this.query, this.parameters, this.domainType, this.returnType, fetchType);
        }
    }
}

