/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.EntityInstanceWithSource;
import org.springframework.data.neo4j.repository.query.Neo4jQuerySupport;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

class DtoInstantiatingConverter
implements Converter<EntityInstanceWithSource, Object> {
    private final Class<?> targetType;
    private final Neo4jMappingContext context;

    DtoInstantiatingConverter(Class<?> dtoType, Neo4jMappingContext context) {
        Assert.notNull(dtoType, (String)"DTO type must not be null!");
        Assert.notNull((Object)context, (String)"MappingContext must not be null!");
        this.targetType = dtoType;
        this.context = context;
    }

    public Object convert(final EntityInstanceWithSource entityInstanceAndSource) {
        if (entityInstanceAndSource == null) {
            return null;
        }
        Object entityInstance = entityInstanceAndSource.getEntityInstance();
        if (this.targetType.isInterface() || this.targetType.isInstance(entityInstance)) {
            return entityInstance;
        }
        final PersistentEntity sourceEntity = this.context.getRequiredPersistentEntity(entityInstance.getClass());
        final PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(entityInstance);
        final PersistentEntity targetEntity = (PersistentEntity)this.context.addPersistentEntity((TypeInformation<?>)ClassTypeInformation.from(this.targetType)).get();
        PreferredConstructor constructor = targetEntity.getPersistenceConstructor();
        Object dto = this.context.getInstantiatorFor(targetEntity).createInstance(targetEntity, new ParameterValueProvider(){

            public Object getParameterValue(PreferredConstructor.Parameter parameter) {
                PersistentProperty targetProperty = targetEntity.getPersistentProperty(parameter.getName());
                if (targetProperty == null) {
                    throw new MappingException("Cannot map constructor parameter " + parameter.getName() + " to a property of class " + DtoInstantiatingConverter.this.targetType);
                }
                return DtoInstantiatingConverter.this.getPropertyValueFor(targetProperty, sourceEntity, sourceAccessor, entityInstanceAndSource);
            }
        });
        PersistentPropertyAccessor dtoAccessor = targetEntity.getPropertyAccessor(dto);
        targetEntity.doWithProperties(property -> {
            if (constructor.isConstructorParameter(property)) {
                return;
            }
            Object propertyValue = this.getPropertyValueFor(property, sourceEntity, sourceAccessor, entityInstanceAndSource);
            dtoAccessor.setProperty(property, propertyValue);
        });
        return dto;
    }

    Object getPropertyValueFor(PersistentProperty<?> targetProperty, PersistentEntity<?, ?> sourceEntity, PersistentPropertyAccessor sourceAccessor, EntityInstanceWithSource entityInstanceAndSource) {
        TypeSystem typeSystem = entityInstanceAndSource.getTypeSystem();
        MapAccessor sourceRecord = entityInstanceAndSource.getSourceRecord();
        String targetPropertyName = targetProperty.getName();
        PersistentProperty sourceProperty = sourceEntity.getPersistentProperty(targetPropertyName);
        if (sourceProperty != null) {
            return sourceAccessor.getProperty(sourceProperty);
        }
        if (!sourceRecord.containsKey(targetPropertyName)) {
            Neo4jQuerySupport.REPOSITORY_QUERY_LOG.warn(() -> String.format("Cannot retrieve a value for property `%s` of DTO `%s` and the property will always be null. Make sure to project only properties of the domain type or use a custom query that returns a mappable data under the name `%1$s`.", targetPropertyName, this.targetType.getName()));
        } else if (targetProperty.isMap()) {
            Neo4jQuerySupport.REPOSITORY_QUERY_LOG.warn(() -> String.format("%s is an additional property to be projected. However, map properties cannot be projected and the property will always be null.", targetPropertyName));
        } else {
            Value property = sourceRecord.get(targetPropertyName);
            if (targetProperty.isCollectionLike() && !typeSystem.LIST().isTypeOf(property)) {
                Neo4jQuerySupport.REPOSITORY_QUERY_LOG.warn(() -> String.format("%s is a list property but the selected value is not a list and the property will always be null.", targetPropertyName));
            } else {
                Function<Value, Object> singleValue;
                Class actualType = targetProperty.getActualType();
                if (this.context.hasPersistentEntityFor(actualType)) {
                    singleValue = p -> this.context.getEntityConverter().read(actualType, p);
                } else {
                    ClassTypeInformation actualTargetType = ClassTypeInformation.from((Class)actualType);
                    singleValue = p -> this.context.getConversionService().readValue((Value)p, (TypeInformation<?>)actualTargetType, null);
                }
                if (targetProperty.isCollectionLike()) {
                    List returnedValues = property.asList(singleValue);
                    Collection target = CollectionFactory.createCollection((Class)targetProperty.getType(), (Class)actualType, (int)returnedValues.size());
                    target.addAll(returnedValues);
                    return target;
                }
                return singleValue.apply(property);
            }
        }
        return null;
    }
}

