/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Optional;
import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.mapping.DefaultRelationshipDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.CompositeProperty;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.springframework.data.neo4j.core.schema.RelationshipProperties;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DefaultNeo4jPersistentProperty
extends AnnotationBasedPersistentProperty<Neo4jPersistentProperty>
implements Neo4jPersistentProperty {
    private final Lazy<String> graphPropertyName;
    private final Lazy<Boolean> isAssociation;
    private final Neo4jMappingContext mappingContext;
    private final Lazy<Neo4jPersistentPropertyConverter> customConversion;

    DefaultNeo4jPersistentProperty(Property property, PersistentEntity<?, Neo4jPersistentProperty> owner, Neo4jMappingContext mappingContext, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        this.mappingContext = mappingContext;
        this.graphPropertyName = Lazy.of(this::computeGraphPropertyName);
        this.isAssociation = Lazy.of(() -> {
            Class targetType = this.getActualType();
            return !simpleTypeHolder.isSimpleType(targetType) && !this.mappingContext.hasCustomWriteTarget(targetType) && !this.isAnnotationPresent(TargetNode.class) && !this.isComposite();
        });
        this.customConversion = Lazy.of(() -> {
            if (this.isEntity()) {
                return null;
            }
            return this.mappingContext.getOptionalCustomConversionsFor(this);
        });
    }

    protected Association<Neo4jPersistentProperty> createAssociation() {
        MutablePersistentEntity obverseOwner;
        boolean dynamicAssociation = this.isDynamicAssociation();
        Neo4jPersistentEntity relationshipPropertiesClass = null;
        if (this.hasActualTypeAnnotation(RelationshipProperties.class)) {
            TypeInformation<?> type = this.getRelationshipPropertiesTargetType(this.getActualType());
            obverseOwner = this.mappingContext.getPersistentEntity((TypeInformation)type);
            relationshipPropertiesClass = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(this.getActualType());
        } else {
            Class<?> associationTargetType = this.getAssociationTargetType();
            obverseOwner = this.mappingContext.addPersistentEntity((TypeInformation<?>)ClassTypeInformation.from(associationTargetType)).get();
            if (dynamicAssociation) {
                TypeInformation mapValueType = this.getTypeInformation().getMapValueType();
                boolean relationshipPropertiesCollection = ((Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(mapValueType.getActualType().getType())).isRelationshipPropertiesEntity();
                boolean relationshipPropertiesScalar = mapValueType.getType().isAnnotationPresent(RelationshipProperties.class);
                if (relationshipPropertiesCollection) {
                    TypeInformation<?> type = this.getRelationshipPropertiesTargetType(mapValueType.getActualType().getType());
                    obverseOwner = this.mappingContext.getPersistentEntity((TypeInformation)type);
                    relationshipPropertiesClass = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(mapValueType.getComponentType().getType());
                } else if (relationshipPropertiesScalar) {
                    relationshipPropertiesClass = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(mapValueType.getType());
                }
            }
        }
        Relationship outgoingRelationship = (Relationship)this.findAnnotation(Relationship.class);
        String type = outgoingRelationship != null && outgoingRelationship.type() != null ? outgoingRelationship.type() : DefaultNeo4jPersistentProperty.deriveRelationshipType(this.getName());
        Relationship.Direction direction = Relationship.Direction.OUTGOING;
        if (outgoingRelationship != null) {
            direction = outgoingRelationship.direction();
        }
        Optional<RelationshipDescription> obverseRelationshipDescription = obverseOwner.getRelationships().stream().filter(rel -> rel.getType().equals(type) && rel.getTarget().equals(this.getOwner())).findFirst();
        DefaultRelationshipDescription relationshipDescription = new DefaultRelationshipDescription(this, obverseRelationshipDescription.orElse(null), type, dynamicAssociation, (NodeDescription)this.getOwner(), this.getName(), (NodeDescription<?>)obverseOwner, direction, relationshipPropertiesClass);
        obverseRelationshipDescription.ifPresent(relationship -> relationship.setRelationshipObverse(relationshipDescription));
        return relationshipDescription;
    }

    @NonNull
    private TypeInformation<?> getRelationshipPropertiesTargetType(Class<?> relationshipPropertiesType) {
        return this.mappingContext.addPersistentEntity((TypeInformation<?>)ClassTypeInformation.from(relationshipPropertiesType)).map(entity -> (Neo4jPersistentProperty)entity.getPersistentProperty(TargetNode.class)).map(PersistentProperty::getTypeInformation).orElseThrow(() -> new MappingException("Missing @TargetNode declaration in " + relationshipPropertiesType));
    }

    public Class<?> getAssociationTargetType() {
        Class associationTargetType = super.getAssociationTargetType();
        if (associationTargetType != null) {
            return associationTargetType;
        }
        if (this.isDynamicOneToManyAssociation()) {
            TypeInformation actualType = this.getTypeInformation().getRequiredActualType();
            return actualType.getRequiredComponentType().getType();
        }
        return null;
    }

    public boolean isAssociation() {
        return (Boolean)this.isAssociation.orElse((Object)false);
    }

    public boolean isEntity() {
        return super.isEntity() && this.isAssociation() || this.isEntityWithRelationshipProperties() && !this.isComposite();
    }

    private static Function<Object, Value> nullSafeWrite(Function<Object, Value> delegate) {
        return source -> source == null ? Values.NULL : (Value)delegate.apply(source);
    }

    @Override
    public Function<Object, Value> getOptionalWritingConverter() {
        return this.customConversion.getOptional().map(c -> DefaultNeo4jPersistentProperty.nullSafeWrite(c::write)).orElse(null);
    }

    private static Function<Value, Object> nullSafeRead(Function<Value, Object> delegate) {
        return source -> source == null || source.isNull() ? null : delegate.apply((Value)source);
    }

    @Override
    public Function<Value, Object> getOptionalReadingConverter() {
        return this.customConversion.getOptional().map(c -> DefaultNeo4jPersistentProperty.nullSafeRead(c::read)).orElse(null);
    }

    @Override
    public boolean isEntityWithRelationshipProperties() {
        return super.isEntity() && ((Neo4jPersistentEntity)this.getOwner()).isRelationshipPropertiesEntity();
    }

    @Nullable
    private String computeGraphPropertyName() {
        if (this.isAssociation()) {
            return null;
        }
        org.springframework.data.neo4j.core.schema.Property propertyAnnotation = (org.springframework.data.neo4j.core.schema.Property)this.findAnnotation(org.springframework.data.neo4j.core.schema.Property.class);
        String targetName = this.getName();
        if (propertyAnnotation != null && !propertyAnnotation.name().isEmpty() && propertyAnnotation.name().trim().length() != 0) {
            targetName = propertyAnnotation.name().trim();
        }
        return targetName;
    }

    @Override
    public String getFieldName() {
        return this.getName();
    }

    @Override
    public String getPropertyName() {
        String propertyName = (String)this.graphPropertyName.getNullable();
        if (propertyName == null) {
            throw new MappingException("The property '" + propertyName + "' is not mapped to a Graph property!");
        }
        return propertyName;
    }

    @Override
    public boolean isInternalIdProperty() {
        return this.isIdProperty() && ((Neo4jPersistentEntity)this.getOwner()).isUsingInternalIds();
    }

    @Override
    public boolean isRelationship() {
        return this.isAssociation();
    }

    @Override
    public boolean isComposite() {
        return this.isAnnotationPresent(CompositeProperty.class);
    }

    static String deriveRelationshipType(String name) {
        int codePoint;
        Assert.hasText((String)name, (String)"The name to derive the type from is required.");
        StringBuilder sb = new StringBuilder();
        int previousIndex = 0;
        for (int i2 = 0; i2 < name.length(); i2 += Character.charCount(codePoint)) {
            codePoint = name.codePointAt(i2);
            if (Character.isLowerCase(codePoint)) {
                if (i2 > 0 && !Character.isLetter(name.codePointAt(previousIndex))) {
                    sb.append("_");
                }
                codePoint = Character.toUpperCase(codePoint);
            } else if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(Character.toChars(codePoint));
            previousIndex = i2;
        }
        return sb.toString();
    }
}

