/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.RecordMapAccessor;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.NoRootNodeMappingException;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class PreparedQuery<T> {
    private final Class<T> resultType;
    private final QueryFragmentsAndParameters queryFragmentsAndParameters;
    @Nullable
    private final Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunctionSupplier;
    private volatile Optional<BiFunction<TypeSystem, Record, T>> lastMappingFunction = Optional.empty();

    public static <CT> RequiredBuildStep<CT> queryFor(Class<CT> resultType) {
        return new RequiredBuildStep(resultType);
    }

    private PreparedQuery(OptionalBuildSteps<T> optionalBuildSteps) {
        this.resultType = optionalBuildSteps.resultType;
        this.mappingFunctionSupplier = optionalBuildSteps.mappingFunctionSupplier;
        this.queryFragmentsAndParameters = optionalBuildSteps.queryFragmentsAndParameters;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public synchronized Optional<BiFunction<TypeSystem, Record, T>> getOptionalMappingFunction() {
        this.lastMappingFunction = Optional.ofNullable(this.mappingFunctionSupplier).map(Supplier::get).map(f -> new AggregatingMappingFunction((BiFunction<TypeSystem, MapAccessor, ?>)f));
        return this.lastMappingFunction;
    }

    synchronized boolean resultsHaveBeenAggregated() {
        return this.lastMappingFunction.filter(AggregatingMappingFunction.class::isInstance).map(AggregatingMappingFunction.class::cast).map(AggregatingMappingFunction::hasAggregated).orElse(false);
    }

    public QueryFragmentsAndParameters getQueryFragmentsAndParameters() {
        return this.queryFragmentsAndParameters;
    }

    private static class AggregatingMappingFunction
    implements BiFunction<TypeSystem, Record, Object> {
        private final BiFunction<TypeSystem, MapAccessor, ?> target;
        private final AtomicBoolean aggregated = new AtomicBoolean(false);

        AggregatingMappingFunction(BiFunction<TypeSystem, MapAccessor, ?> target) {
            this.target = target;
        }

        private Collection<?> aggregateList(TypeSystem t, Value value) {
            if (MappingSupport.isListContainingOnly(t.LIST(), t.PATH()).test(value)) {
                return new LinkedHashSet(this.aggregatePath(t, value, Collections.emptyList()));
            }
            return value.asList(v -> this.target.apply(t, (MapAccessor)v));
        }

        private Collection<?> aggregatePath(TypeSystem t, Value value, List<Map.Entry<String, Value>> additionalValues) {
            LinkedHashSet result = new LinkedHashSet();
            LinkedHashSet<Value> nodes = new LinkedHashSet<Value>();
            LinkedHashSet<Value> relationships = new LinkedHashSet<Value>();
            List paths = value.hasType(t.PATH()) ? Collections.singletonList(value.asPath()) : value.asList(Value::asPath);
            for (Path path : paths) {
                Node lastNode = null;
                for (Path.Segment segment : path) {
                    Node start = segment.start();
                    if (start != null) {
                        nodes.add(Values.value((Object)start));
                    }
                    lastNode = segment.end();
                    relationships.add(Values.value((Object)segment.relationship()));
                }
                if (lastNode == null) continue;
                nodes.add(Values.value(lastNode));
            }
            HashMap<String, Value> mapValue = new HashMap<String, Value>();
            additionalValues.forEach(e -> {
                Value cfr_ignored_0 = (Value)mapValue.put((String)e.getKey(), (Value)e.getValue());
            });
            mapValue.put("__sr__", Values.value(relationships));
            mapValue.put("__srn__", Values.value(nodes));
            for (Value rootNode : nodes) {
                mapValue.put("__sn__", rootNode);
                try {
                    result.add(this.target.apply(t, (MapAccessor)Values.value(mapValue)));
                }
                catch (NoRootNodeMappingException noRootNodeMappingException) {}
            }
            return result;
        }

        @Override
        public Object apply(TypeSystem t, Record r) {
            if (r.size() == 1) {
                Value value = r.get(0);
                if (value.hasType(t.LIST())) {
                    this.aggregated.compareAndSet(false, true);
                    return this.aggregateList(t, value);
                }
                if (value.hasType(t.PATH())) {
                    this.aggregated.compareAndSet(false, true);
                    return this.aggregatePath(t, value, Collections.emptyList());
                }
            }
            try {
                return this.target.apply(t, new RecordMapAccessor(r));
            }
            catch (NoRootNodeMappingException e) {
                Map<Boolean, List<Map.Entry>> pathValues = r.asMap(Function.identity()).entrySet().stream().collect(Collectors.partitioningBy(entry -> ((Value)entry.getValue()).hasType(t.PATH())));
                if (pathValues.get(true).size() == 1) {
                    this.aggregated.compareAndSet(false, true);
                    return this.aggregatePath(t, (Value)pathValues.get(true).get(0).getValue(), pathValues.get(false));
                }
                throw e;
            }
        }

        boolean hasAggregated() {
            return this.aggregated.get();
        }
    }

    public static class OptionalBuildSteps<CT> {
        final Class<CT> resultType;
        final QueryFragmentsAndParameters queryFragmentsAndParameters;
        @Nullable
        Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunctionSupplier;

        OptionalBuildSteps(Class<CT> resultType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
            this.resultType = resultType;
            this.queryFragmentsAndParameters = queryFragmentsAndParameters;
        }

        public OptionalBuildSteps<CT> withParameters(Map<String, Object> newParameters) {
            this.queryFragmentsAndParameters.setParameters(newParameters);
            return this;
        }

        @Deprecated
        public OptionalBuildSteps<CT> usingMappingFunction(@Nullable BiFunction<TypeSystem, MapAccessor, ?> newMappingFunction) {
            this.mappingFunctionSupplier = newMappingFunction == null ? null : () -> newMappingFunction;
            return this;
        }

        public OptionalBuildSteps<CT> usingMappingFunction(@Nullable Supplier<BiFunction<TypeSystem, MapAccessor, ?>> newMappingFunction) {
            this.mappingFunctionSupplier = newMappingFunction;
            return this;
        }

        public PreparedQuery<CT> build() {
            return new PreparedQuery(this);
        }
    }

    public static class RequiredBuildStep<CT> {
        private final Class<CT> resultType;

        private RequiredBuildStep(Class<CT> resultType) {
            this.resultType = resultType;
        }

        public OptionalBuildSteps<CT> withCypherQuery(String cypherQuery) {
            return new OptionalBuildSteps<CT>(this.resultType, new QueryFragmentsAndParameters(cypherQuery));
        }

        public OptionalBuildSteps<CT> withQueryFragmentsAndParameters(QueryFragmentsAndParameters queryFragmentsAndParameters) {
            return new OptionalBuildSteps<CT>(this.resultType, queryFragmentsAndParameters);
        }
    }
}

