/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

final class DefaultNeo4jConversionService
implements Neo4jConversionService {
    private final ConversionService conversionService;
    private final Predicate<Class<?>> hasCustomWriteTargetPredicate;
    private final SimpleTypeHolder simpleTypes;

    DefaultNeo4jConversionService(Neo4jConversions neo4jConversions) {
        DefaultConversionService configurableConversionService = new DefaultConversionService();
        neo4jConversions.registerConvertersIn((ConverterRegistry)configurableConversionService);
        this.conversionService = configurableConversionService;
        this.hasCustomWriteTargetPredicate = arg_0 -> ((Neo4jConversions)neo4jConversions).hasCustomWriteTarget(arg_0);
        this.simpleTypes = neo4jConversions.getSimpleTypeHolder();
    }

    @Override
    @Nullable
    public <T> T convert(Object source, Class<T> targetType) {
        return (T)this.conversionService.convert(source, targetType);
    }

    @Override
    public boolean hasCustomWriteTarget(Class<?> sourceType) {
        return this.hasCustomWriteTargetPredicate.test(sourceType);
    }

    @Override
    @Nullable
    public Object readValue(@Nullable Value source, TypeInformation<?> targetType, @Nullable Function<Value, Object> conversionOverride) {
        BiFunction<Value, Class<?>, Object> conversion = conversionOverride == null ? (v, t) -> this.conversionService.convert(v, t) : (v, t) -> conversionOverride.apply((Value)v);
        return this.readValueImpl(source, targetType, conversion);
    }

    @Nullable
    private Object readValueImpl(@Nullable Value value, TypeInformation<?> type, BiFunction<Value, Class<?>, Object> conversion) {
        boolean valueIsLiteralNullOrNullValue = value == null || value == Values.NULL;
        try {
            Class rawType = type.getType();
            if (!valueIsLiteralNullOrNullValue && DefaultNeo4jConversionService.isCollection(type)) {
                Collection target = CollectionFactory.createCollection((Class)rawType, (Class)type.getComponentType().getType(), (int)value.size());
                value.values().forEach(element -> target.add(conversion.apply((Value)element, type.getComponentType().getType())));
                return target;
            }
            return valueIsLiteralNullOrNullValue ? null : conversion.apply(value, rawType);
        }
        catch (Exception e) {
            String msg = String.format("Could not convert %s into %s", value, type);
            throw new TypeMismatchDataAccessException(msg, (Throwable)e);
        }
    }

    @Override
    public Value writeValue(@Nullable Object value, TypeInformation<?> sourceType, @Nullable Function<Object, Value> writingConverter) {
        Function<Object, Value> conversion = writingConverter == null ? v -> (Value)this.conversionService.convert(v, Value.class) : writingConverter;
        return this.writeValueImpl(value, sourceType, conversion);
    }

    private Value writeValueImpl(@Nullable Object value, TypeInformation<?> type, Function<Object, Value> conversion) {
        if (value == null) {
            try {
                return conversion.apply(null);
            }
            catch (NullPointerException e) {
                return Values.NULL;
            }
        }
        if (DefaultNeo4jConversionService.isCollection(type)) {
            Collection sourceCollection = (Collection)value;
            Object[] targetCollection = sourceCollection.stream().map(conversion::apply).toArray();
            return Values.value((Object)targetCollection);
        }
        return conversion.apply(value);
    }

    private static boolean isCollection(TypeInformation<?> type) {
        return Collection.class.isAssignableFrom(type.getType());
    }

    @Override
    public boolean isSimpleType(Class<?> type) {
        return this.simpleTypes.isSimpleType(type);
    }
}

