/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.event;

import org.apiguardian.api.API;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.neo4j.repository.event.ReactiveBeforeBindCallback;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public final class ReactiveAuditingBeforeBindCallback
implements ReactiveBeforeBindCallback<Object>,
Ordered {
    public static final int NEO4J_REACTIVE_AUDITING_ORDER = 100;
    private final ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory;

    public ReactiveAuditingBeforeBindCallback(ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public Publisher<Object> onBeforeBind(Object entity) {
        return ((ReactiveIsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity);
    }

    public int getOrder() {
        return 100;
    }
}

