/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.event;

import org.apiguardian.api.API;
import org.springframework.core.Ordered;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.event.BeforeBindCallback;
import org.springframework.data.neo4j.repository.event.IdPopulator;

@API(status=API.Status.INTERNAL, since="6.0")
public final class IdGeneratingBeforeBindCallback
implements BeforeBindCallback<Object>,
Ordered {
    private final IdPopulator idPopulator;

    public IdGeneratingBeforeBindCallback(Neo4jMappingContext neo4jMappingContext) {
        this.idPopulator = new IdPopulator(neo4jMappingContext);
    }

    @Override
    public Object onBeforeBind(Object entity) {
        return this.idPopulator.populateIfNecessary(entity);
    }

    public int getOrder() {
        return 110;
    }
}

