/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class NestedRelationshipContext {
    private final Neo4jPersistentProperty inverse;
    private final Object value;
    private final RelationshipDescription relationship;
    private final Class<?> associationTargetType;
    private final boolean inverseValueIsEmpty;

    private NestedRelationshipContext(Neo4jPersistentProperty inverse, @Nullable Object value, RelationshipDescription relationship, Class<?> associationTargetType, boolean inverseValueIsEmpty) {
        this.inverse = inverse;
        this.value = value;
        this.relationship = relationship;
        this.associationTargetType = associationTargetType;
        this.inverseValueIsEmpty = inverseValueIsEmpty;
    }

    public Neo4jPersistentProperty getInverse() {
        return this.inverse;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public RelationshipDescription getRelationship() {
        return this.relationship;
    }

    public Class<?> getAssociationTargetType() {
        return this.associationTargetType;
    }

    public boolean inverseValueIsEmpty() {
        return this.inverseValueIsEmpty;
    }

    boolean hasRelationshipWithProperties() {
        return this.relationship.hasRelationshipProperties();
    }

    public Object identifyAndExtractRelationshipTargetNode(Object relatedValue) {
        Object valueToBeSaved = relatedValue;
        if (relatedValue instanceof Map.Entry) {
            Map.Entry relatedValueMapEntry = (Map.Entry)relatedValue;
            if (this.hasRelationshipWithProperties()) {
                Object mapValue = ((Map.Entry)relatedValue).getValue();
                mapValue = mapValue instanceof List ? ((List)mapValue).get(0) : mapValue;
                valueToBeSaved = ((MappingSupport.RelationshipPropertiesWithEntityHolder)mapValue).getRelatedEntity();
            } else if (this.getInverse().isDynamicAssociation()) {
                valueToBeSaved = relatedValueMapEntry.getValue();
            }
        } else if (this.hasRelationshipWithProperties()) {
            valueToBeSaved = ((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValue).getRelatedEntity();
        }
        return valueToBeSaved;
    }

    public static NestedRelationshipContext of(Association<Neo4jPersistentProperty> handler, PersistentPropertyAccessor<?> propertyAccessor, Neo4jPersistentEntity<?> neo4jPersistentEntity) {
        Neo4jPersistentProperty inverse = (Neo4jPersistentProperty)handler.getInverse();
        boolean inverseValueIsEmpty = propertyAccessor.getProperty((PersistentProperty)inverse) == null;
        Cloneable value = propertyAccessor.getProperty((PersistentProperty)inverse);
        RelationshipDescription relationship = neo4jPersistentEntity.getRelationships().stream().filter(r -> r.getFieldName().equals(inverse.getName())).findFirst().get();
        Class associationTargetType = inverse.getAssociationTargetType();
        if (relationship.hasRelationshipProperties() && value != null) {
            Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationship.getRelationshipPropertiesEntity();
            if (relationship.isDynamic()) {
                HashMap relationshipProperties = new HashMap();
                for (Map.Entry mapEntry : ((Map)((Object)value)).entrySet()) {
                    ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder> relationshipValues = new ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder>();
                    relationshipProperties.put(mapEntry.getKey(), relationshipValues);
                    Object mapEntryValue = mapEntry.getValue();
                    if (mapEntryValue instanceof List) {
                        for (Object relationshipProperty : (List)mapEntryValue) {
                            MappingSupport.RelationshipPropertiesWithEntityHolder oneOfThem = new MappingSupport.RelationshipPropertiesWithEntityHolder(relationshipProperty, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, relationshipProperty));
                            relationshipValues.add(oneOfThem);
                        }
                        continue;
                    }
                    MappingSupport.RelationshipPropertiesWithEntityHolder oneOfThem = new MappingSupport.RelationshipPropertiesWithEntityHolder(mapEntryValue, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, mapEntryValue));
                    relationshipValues.add(oneOfThem);
                }
                value = relationshipProperties;
            } else if (inverse.isCollectionLike()) {
                ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder> relationshipProperties = new ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder>();
                for (Object relationshipProperty : (Collection)((Object)value)) {
                    MappingSupport.RelationshipPropertiesWithEntityHolder oneOfThem = new MappingSupport.RelationshipPropertiesWithEntityHolder(relationshipProperty, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, relationshipProperty));
                    relationshipProperties.add(oneOfThem);
                }
                value = relationshipProperties;
            } else {
                value = new MappingSupport.RelationshipPropertiesWithEntityHolder(value, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, value));
            }
        }
        return new NestedRelationshipContext(inverse, value, relationship, associationTargetType, inverseValueIsEmpty);
    }

    private static Object getTargetNode(Neo4jPersistentEntity<?> relationshipPropertiesEntity, Object object) {
        PersistentPropertyAccessor propertyAccessor = relationshipPropertiesEntity.getPropertyAccessor(object);
        return propertyAccessor.getProperty(relationshipPropertiesEntity.getPersistentProperty(TargetNode.class));
    }
}

