/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.neo4j.ogm.context.SingleUseEntityMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.EntityInstantiator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.repository.query.QueryResultInstantiator;
import org.springframework.data.neo4j.repository.query.QueryResultProxy;

class CustomResultConverter
implements Converter<Object, Object> {
    private final MetaData metaData;
    private final Class returnedType;
    private final QueryResultInstantiator entityInstantiator;

    CustomResultConverter(MetaData metaData, Class<?> returnedType, QueryResultInstantiator entityInstantiator) {
        this.metaData = metaData;
        this.returnedType = returnedType;
        this.entityInstantiator = entityInstantiator;
    }

    public Object convert(Object source) {
        if (this.returnedType.getAnnotation(QueryResult.class) == null) {
            return source;
        }
        if (this.returnedType.isInterface()) {
            Class[] interfaces = new Class[]{this.returnedType};
            return Proxy.newProxyInstance(this.returnedType.getClassLoader(), interfaces, (InvocationHandler)new QueryResultProxy((Map)source));
        }
        SingleUseEntityMapper mapper = new SingleUseEntityMapper(this.metaData, (EntityInstantiator)this.entityInstantiator);
        return mapper.map(this.returnedType, (Map)source);
    }
}

