/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.neo4j.repository.query.GraphParameterAccessor;
import org.springframework.data.neo4j.repository.query.GraphParameters;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public class GraphParametersParameterAccessor
extends ParametersParameterAccessor
implements GraphParameterAccessor {
    private static final int DEFAULT_QUERY_DEPTH = 1;
    private final GraphQueryMethod method;

    public GraphParametersParameterAccessor(GraphQueryMethod method, Object[] values) {
        super((Parameters)method.getParameters(), values);
        this.method = method;
    }

    @Override
    public int getDepth() {
        Depth methodAnnotation = (Depth)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method.getMethod(), Depth.class);
        if (methodAnnotation != null) {
            Object value = AnnotationUtils.getValue((Annotation)methodAnnotation);
            return value == null ? 1 : (Integer)value;
        }
        GraphParameters graphParameters = this.method.getParameters();
        int depthIndex = graphParameters.getDepthIndex();
        if (depthIndex != -1) {
            return (Integer)this.getValue(depthIndex);
        }
        return 1;
    }

    @Override
    public SortOrder getOgmSort() {
        SortOrder sortOrder = new SortOrder();
        if (this.getSort() != null) {
            for (Sort.Order order : this.getSort()) {
                if (order.isAscending()) {
                    sortOrder.add(new String[]{order.getProperty()});
                    continue;
                }
                sortOrder.add(SortOrder.Direction.DESC, new String[]{order.getProperty()});
            }
        }
        return sortOrder;
    }
}

