/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.config.Neo4jMappingContextFactoryBean;
import org.springframework.data.neo4j.repository.support.Neo4jAuditingBeanFactoryPostProcessor;
import org.springframework.data.neo4j.repository.support.Neo4jPersistenceExceptionTranslator;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactoryBean;
import org.springframework.data.neo4j.transaction.SharedSessionCreator;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class Neo4jRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private static final String NEO4J_MAPPING_CONTEXT_BEAN_NAME = "neo4jMappingContext";
    private static final String NEO4J_AUDITING_POST_PROCESSOR_NAME = "neo4jAuditionBeanFactoryPostProcessor";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";
    private static final String NEO4J_SHARED_SESSION_CREATOR_BEAN_NAME = "sharedSessionCreatorBean";
    private static final String NEO4J_PERSISTENCE_EXCEPTION_TRANSLATOR_NAME = "neo4jPersistenceExceptionTranslator";
    private static final String MODULE_PREFIX = "neo4j";
    private static final String MODULE_NAME = "Neo4j";

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getRepositoryFactoryBeanClassName() {
        return Neo4jRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return MODULE_PREFIX;
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(NodeEntity.class, RelationshipEntity.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(Neo4jRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        String transactionManagerRefPropertyName = "transactionManagerRef";
        String transactionManagerPropertyName = DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
        String mappingContextPropertyName = "mappingContext";
        Optional transactionManagerRef = source.getAttribute(transactionManagerRefPropertyName);
        builder.addPropertyValue(transactionManagerPropertyName, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
        builder.addPropertyReference(mappingContextPropertyName, NEO4J_MAPPING_CONTEXT_BEAN_NAME);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Optional enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (enableDefaultTransactions.filter(StringUtils::hasText).isPresent()) {
            enableDefaultTransactions.ifPresent(value -> builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, value));
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)this.createSharedSessionCreatorBeanDefinition(config), (BeanDefinitionRegistry)registry, (String)NEO4J_SHARED_SESSION_CREATOR_BEAN_NAME, (Object)source);
        Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(Neo4jMappingContextFactoryBean.class), (BeanDefinitionRegistry)registry, (String)NEO4J_MAPPING_CONTEXT_BEAN_NAME, (Object)source);
        Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(Neo4jAuditingBeanFactoryPostProcessor.class), (BeanDefinitionRegistry)registry, (String)NEO4J_AUDITING_POST_PROCESSOR_NAME, (Object)source);
        Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(Neo4jPersistenceExceptionTranslator.class), (BeanDefinitionRegistry)registry, (String)NEO4J_PERSISTENCE_EXCEPTION_TRANSLATOR_NAME, (Object)source);
    }

    private AbstractBeanDefinition createSharedSessionCreatorBeanDefinition(RepositoryConfigurationSource config) {
        String sessionFactoryRefPropertyName = "sessionFactoryRef";
        String sessionFactoryBeanName = config.getAttribute(sessionFactoryRefPropertyName).orElse(DEFAULT_SESSION_FACTORY_BEAN_NAME);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SharedSessionCreator.class, (String)"createSharedSession");
        builder.addConstructorArgReference(sessionFactoryBeanName);
        return builder.getBeanDefinition();
    }
}

