/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.util.Collections;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.lang.Nullable;

public class Neo4jMappingContextIsNewStrategyFactory
extends MappingContextIsNewStrategyFactory {
    private final PersistentEntities context;

    public Neo4jMappingContextIsNewStrategyFactory(MappingContext<? extends PersistentEntity<?, ?>, ?> context) {
        this(new PersistentEntities(Collections.singletonList(context)));
    }

    public Neo4jMappingContextIsNewStrategyFactory(PersistentEntities entities) {
        super(entities);
        this.context = entities;
    }

    @Nullable
    protected IsNewStrategy doGetIsNewStrategy(final Class<?> type) {
        return new IsNewStrategy(){

            public boolean isNew(Object o) {
                PersistentEntity entity = Neo4jMappingContextIsNewStrategyFactory.this.context.getRequiredPersistentEntity(type);
                PersistentProperty property = entity.getRequiredIdProperty();
                Object value = property.getOwner().getPropertyAccessor(o).getProperty(property);
                return value == null || value instanceof Long && (Long)value < 0L;
            }
        };
    }
}

