/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.config.Neo4jMappingContextFactoryBean;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactoryBean;
import org.springframework.data.neo4j.repository.support.SessionBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class Neo4jRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String NEO4J_MAPPING_CONTEXT_BEAN_NAME = "neo4jMappingContext";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";
    private static final String SESSION_BEAN_DEFINITION_REGISTRAR_POST_PROCESSOR_BEAN_NAME = "sessionBeanDefinitionRegistrarPostProcessor";

    public String getModuleName() {
        return "Neo4j";
    }

    public String getRepositoryFactoryClassName() {
        return Neo4jRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "neo4j";
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(NodeEntity.class, RelationshipEntity.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(Neo4jRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        String transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)(transactionManagerRef == null ? DEFAULT_TRANSACTION_MANAGER_BEAN_NAME : transactionManagerRef));
        builder.addPropertyReference("mappingContext", NEO4J_MAPPING_CONTEXT_BEAN_NAME);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        String enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (StringUtils.hasText((String)enableDefaultTransactions)) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)enableDefaultTransactions);
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(SessionBeanDefinitionRegistrarPostProcessor.class), (BeanDefinitionRegistry)registry, (String)SESSION_BEAN_DEFINITION_REGISTRAR_POST_PROCESSOR_BEAN_NAME, (Object)source);
        Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(Neo4jMappingContextFactoryBean.class), (BeanDefinitionRegistry)registry, (String)NEO4J_MAPPING_CONTEXT_BEAN_NAME, (Object)source);
    }
}

